Group: Development/Java
BuildRequires: /proc rpm-build-java
BuildRequires: jpackage-11-compat
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global srcname metro-xmlstreambuffer

Name:           xmlstreambuffer
Version:        1.5.9
Release:        alt1_1jpp11
Summary:        Stream Based Representation for XML Infoset
License:        BSD

URL:            https://github.com/eclipse-ee4j/metro-xmlstreambuffer
Source0:        %{url}/archive/%{version}/%{srcname}-%{version}.tar.gz

BuildArch:      noarch

BuildRequires:  maven-local
BuildRequires:  mvn(com.fasterxml.woodstox:woodstox-core)
BuildRequires:  mvn(jakarta.activation:jakarta.activation-api)
BuildRequires:  mvn(junit:junit)
BuildRequires:  mvn(org.apache.felix:maven-bundle-plugin)
BuildRequires:  mvn(org.codehaus.mojo:build-helper-maven-plugin)
BuildRequires:  mvn(org.jvnet.staxex:stax-ex)

# javadoc subpackage is currently not built
Obsoletes:      xmlstreambuffer-javadoc < 1.5.9-1
Source44: import.info

%description
Stream based representation for XML infoset.


%prep
%setup -q -n %{srcname}-%{version}

pushd streambuffer
# remove unnecessary dependency on parent POM
%pom_remove_parent

# remove unnecessary maven plugins
%pom_remove_plugin :buildnumber-maven-plugin
%pom_remove_plugin :glassfish-copyright-maven-plugin
%pom_remove_plugin :maven-enforcer-plugin
popd


%build
pushd streambuffer
# skip javadoc build due to https://github.com/fedora-java/xmvn/issues/58
%mvn_build -j -- -DbuildNumber=unknown
popd


%install
pushd streambuffer
%mvn_install
popd


%files -f streambuffer/.mfiles
%doc --no-dereference LICENSE.md NOTICE.md
%doc README.md


%changelog
