%def_disable snapshot

%define _name xf86-input-libinput
%define _xconfdir %_sysconfdir/X11/xorg.conf.d

%def_enable check

Name: xorg-drv-libinput
Version: 1.2.1
Release: alt1

Summary: Xorg libinput input driver
Group: System/X11
License: MIT
Url: https://gitlab.freedesktop.org/xorg/driver/xf86-input-libinput

%if_enabled snapshot
Vcs: https://gitlab.freedesktop.org/xorg/driver/xf86-input-libinput.git
Source: %_name-%version.tar
%else
Source: ftp://ftp.x.org/pub/individual/driver/%_name-%version.tar.xz
%endif
Patch: xf86-input-libinput-0.14.0-alt-include.patch

%define libinput_ver 1.11
%define xproto_ver 2.3.99.1

Requires(pre): XORG_ABI_XINPUT = %get_xorg_abi_xinput
Requires: libinput >= %libinput_ver
Requires: xkeyboard-config

BuildRequires(pre): xorg-sdk >= 1.19
BuildRequires: libinput-devel >= %libinput_ver xorg-proto-devel >= %xproto_ver

%description
This is an X driver based on libinput. It is a thin wrapper around libinput,
so while it does provide all features that libinput supports it does little
beyond.

***WARNING: misconfiguration of an X input driver may leave you without
usable input devices in your X session. Use with caution.***

%package devel
Summary: Xorg libinput input driver development package
Group: Development/C
Requires: %name = %version-%release

%description devel
Xorg libinput input driver development files.

%prep
%setup -n %_name-%version
%patch

%build
%add_optflags %(getconf LFS_CFLAGS)
%autoreconf
%configure --disable-static \
	--with-xorg-module-dir=%_x11modulesdir \
	--with-xorg-conf-dir=%_xconfdir
%make_build

%install
%makeinstall_std

%check
%make -k check VERBOSE=1

%files
%config(noreplace) %_xconfdir/40-libinput.conf
%_x11modulesdir/input/libinput_drv.so
%_man4dir/libinput.4*
%doc README.* COPYING

%exclude %_x11modulesdir/input/libinput_drv.la

%files devel
%_pkgconfigdir/xorg-libinput.pc
%_includedir/xorg/libinput-properties.h

%changelog
