%define oldname xsom
Group: Development/Java
BuildRequires: /proc rpm-build-java
BuildRequires: jpackage-11-compat
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           xsom20140514
Summary:        XML Schema Object Model (XSOM)
Version:        20140514
Release:        alt4_3jpp11
License:        CDDL-1.1 or GPLv2 with exceptions

# java.net is dead; upstream sources have been imported to GitHub though
URL:            https://github.com/kohsuke/xsom
Source0:        %{url}/archive/%{oldname}-%{version}.tar.gz

# We need this because one of the original tests tries to download
# it from the website, but that doesn't work in Koji:
Source1: http://docs.oasis-open.org/regrep/v3.0/schema/lcm.xsd

# patch POM to drop tasks that rely on bundled JARs
Patch0:         00-pom-changes.patch
Patch33:	xsom-no-target-15.patch

BuildRequires:  relaxngcc
BuildRequires:  maven-local
BuildRequires:  mvn(junit:junit)
BuildRequires:  mvn(org.apache.maven.plugins:maven-antrun-plugin)
BuildRequires:  mvn(org.codehaus.mojo:build-helper-maven-plugin)
BuildRequires:  mvn(relaxngDatatype:relaxngDatatype:20020414)

BuildArch:      noarch
Source44: import.info

%description
XML Schema Object Model (XSOM) is a Java library that allows applications to
easily parse XML Schema documents and inspect information in them. It is
expected to be useful for applications that need to take XML Schema as an
input.  The library is a straight-forward implement of "schema components" as
defined in the XML Schema spec part 1.  Refer to this specification of how this
object model works. 

%package javadoc
Group: Development/Java
Summary:        Javadoc for %{oldname}
BuildArch: noarch

%description javadoc
This package contains javadoc for %{oldname}.

%prep
%setup -q -n %{oldname}-%{oldname}-%{version}
%patch0 -p1
%patch33 -p1

find -name "*.class" -print -delete
find -name "*.jar" -print -delete

# parent POM is not necessary
%pom_remove_parent

# Replace the URL of the XSD file used by the tests with its
# absolute filesystem location:
sed -i \
  's|http://docs.oasis-open.org/regrep/v3.0/schema/lcm.xsd|file://%{SOURCE1}|' \
  test/XSOMParserTest.java

pushd lib
ln -sf `build-classpath relaxngcc` relaxngcc.jar
popd

%mvn_compat_version : 20110809 20140925 %{version}

%build
%mvn_build -- -Dmaven.compile.source=1.8 -Dmaven.compile.target=1.8 -Dmaven.javadoc.source=1.8 -Dproject.build.sourceEncoding=UTF-8 -P regenerate-sources

%install
%mvn_install

%files -f .mfiles
%doc --no-dereference license.txt copyright.txt

%files javadoc -f .mfiles-javadoc
%doc --no-dereference license.txt copyright.txt

%changelog
