%define py_name yt_dlp

Name: yt-dlp
Version: 2025.01.26
Release: alt1

Summary: A tool for downloading from video services for offline watching
License: Unlicense
Group: Networking/File transfer
Url: https://github.com/yt-dlp/yt-dlp

Source0: %name-%version.tar

BuildArch: noarch

Requires: python3-module-%py_name = %EVR

# The curl_cffi module is optional (but recommended) and
# is not currently packaged in ALT.
%add_python3_req_skip curl_cffi.const curl_cffi.requests

# Automatically added by buildreq on Tue Jun 18 2024
# optimized out: libgpg-error python3 python3-base python3-dev python3-module-packaging python3-module-pathspec python3-module-pluggy python3-module-trove-classifiers sh5
BuildRequires: python3-module-hatchling python3-module-pyproject-installer python3-module-setuptools

BuildRequires(pre): rpm-build-python3

# In the p10 branch, the python3-module-wheel package doesn't
# pull in setuptools.
BuildPreReq: python3-module-setuptools

%description
yt-dlp is a small command-line program to retrieve videos from
YouTube.com and other video hosting services for offline watching.

A youtube-dl fork with additional features and fixes.

%package -n python3-module-%py_name
Group: Development/Python
Summary: Python 3 module for yt-dlp

%description -n python3-module-%py_name
yt-dlp is a small command-line program to retrieve videos from
YouTube.com and other video hosting services for offline watching.

A youtube-dl fork with additional features and fixes.

This package contains Python 3 module.

%prep
%setup

%build
%pyproject_build

%install
%pyproject_install

rm %buildroot/usr/share/doc/yt_dlp/README.txt
rm -r %buildroot%python3_sitelibdir/%py_name/__pyinstaller

%define _unpackaged_files_terminate_build 1

%files
%_bindir/yt-dlp
%_man1dir/yt-dlp.1.*
%doc README.txt

%_datadir/bash-completion/completions/yt-dlp
%_datadir/fish/vendor_completions.d/yt-dlp.fish
%_datadir/zsh/site-functions/_yt-dlp

%files -n python3-module-%py_name
%python3_sitelibdir/%py_name
%python3_sitelibdir/%py_name-*.dist-info

%changelog
