%define _unpackaged_files_terminate_build 1

Name: z3
Version: 4.8.8
Release: alt1
Summary: High-performance theorem prover
License: MIT
Group: Sciences/Mathematics
Url: https://github.com/Z3Prover/z3

# https://github.com/Z3Prover/z3.git
Source: %name-%version.tar

BuildRequires(pre): rpm-macros-make
BuildRequires(pre): rpm-build-python3
BuildRequires: cmake
BuildRequires: gcc-c++ doxygen graphviz
BuildRequires: libgmp-devel libgmpxx-devel
BuildRequires: python3-devel
BuildRequires: python3(pkg_resources)

%description
Z3 is a high-performance theorem prover being developed at Microsoft
Research.

%package -n lib%name
Summary: Shared library of %name
Group: System/Libraries

%description -n lib%name
Z3 is a high-performance theorem prover being developed at Microsoft
Research.

This package contains shared library of %name.

%package -n lib%name-devel
Summary: Development files of %name
Group: Development/C++
Requires: lib%name = %EVR

%description -n lib%name-devel
Z3 is a high-performance theorem prover being developed at Microsoft
Research.

This package contains development files of %name.

%package -n lib%name-devel-docs
Summary: Documentation for %name
Group: Development/Documentation
BuildArch: noarch

%description -n lib%name-devel-docs
Z3 is a high-performance theorem prover being developed at Microsoft
Research.

This package contains documentation for %name.

%package -n python3-module-%name
Summary: Python bindings of %name
Group: Development/Python3
BuildArch: noarch
Requires: lib%name = %EVR
%py3_provides %name

%description -n python3-module-%name
Z3 is a high-performance theorem prover being developed at Microsoft
Research.

This package contains Python bindings of %name.

%prep
%setup

%build
%cmake \
	-DZ3_INCLUDE_GIT_HASH:BOOL=OFF \
	-DZ3_INCLUDE_GIT_DESCRIBE:BOOL=OFF \
	-DZ3_BUILD_DOCUMENTATION:BOOL=ON \
	-DZ3_ENABLE_EXAMPLE_TARGETS:BOOL=OFF \
	-DPYTHON_EXECUTABLE=$(which python3) \
	-DZ3_BUILD_PYTHON_BINDINGS:BOOL=ON \
	-DZ3_INSTALL_PYTHON_BINDINGS:BOOL=ON \
	-DZ3_USE_LIB_GMP:BOOL=ON \
	%nil

%cmake_build

%install
%cmakeinstall_std

%check
export LD_LIBRARY_PATH=%buildroot%_libdir
export PYTHONPATH=%buildroot%python3_sitelibdir_noarch
python3 -c "import z3; print (z3.get_version_string())"
python3 examples/python/example.py

%files
%doc LICENSE.txt
%doc README-CMake.md README.md
%doc RELEASE_NOTES
%_bindir/*

%files -n lib%name
%_libdir/*.so.*

%files -n lib%name-devel
%_includedir/*
%_libdir/*.so
%_libdir/cmake/%name

%files -n lib%name-devel-docs
%doc examples
%_defaultdocdir/Z3

%files -n python3-module-%name
%python3_sitelibdir_noarch/*

%changelog
