%def_without dbus

Name: FlightGear
Version: 2024.1.1
Release: alt1

Summary: Libre flight simulator
License: GPL-2.0-or-later
Group: Games/Arcade
Url: https://www.flightgear.org
Vcs: https://gitlab.com/flightgear/flightgear.git

Source0: %name-%version.tar
Patch1: 0001-check-to-be-sure-that-n-is-not-being-set-as-format-t.patch
Patch6: 0006-make-fglauncher-a-static-library.patch
Patch7: 0006-fgviewer-fix-crash-on-exit.patch

Requires: FlightGear-data = %version
#Requires: fgrun >= 1.6.1

BuildRequires: libsimgear-devel = %version
BuildRequires: libOpenSceneGraph-devel >= 3.4.0
BuildRequires: boost-devel >= 1.44
BuildRequires: plib-devel >= 1.8.5
BuildRequires: cppunit-devel
BuildRequires: libsqlite3-devel
BuildRequires: libcurl-devel

# TODO: fltk??
BuildRequires: rpm-macros-cmake cmake gcc-c++ imake libalut-devel libfltk-devel libfreeglut-devel libjpeg-devel libpng-devel

BuildRequires: libpng-devel libfltk-devel libudev-devel
BuildRequires: libXres-devel libXi-devel libXmu-devel
BuildRequires: libXtst-devel libXcomposite-devel libXcursor-devel
BuildRequires: libXdamage-devel libXdmcp-devel libXfixes-devel
BuildRequires: libXft-devel libXinerama-devel libxkbfile-devel
BuildRequires: libXpm-devel libXrandr-devel libXrender-devel
BuildRequires: libXScrnSaver-devel libXv-devel libXxf86misc-devel
BuildRequires: libXxf86vm-devel libXxf86vm-devel libapr1-devel
BuildRequires: liblzma-devel

%if_with dbus
# disables screensaver; requires running messagebus service
BuildRequires: libdbus-devel
Requires: dbus
%endif

%ifarch %e2k
# had to disable in OpenSceneGraph => unmets followed up
%global __find_debuginfo_files %nil
%endif

%description
FlightGear is a free, open-source, multi-platform, and sophisticated
flight simulator framework for the development and pursuit
of interesting flight simulator ideas.

This package contains the engine; see also fgrun or fgo to start
FlightGear conveniently.

You will also need some experience and probably a tutorial:
http://ericbrasseur.org/flight_simulator_tutorial.html

%prep
%setup
%autopatch -p1

sed -i 's/\r//' docs-mini/AptNavFAQ.FlightGear.html
for ext in Cygwin IRIX Joystick Linux MSVC MSVC8 MacOS SimGear Unix \
	Win32-X autoconf mingw plib src xmlsyntax; do
	rm -f docs-mini/README.$ext
done
for f in docs-mini/README.xmlparticles Thanks; do
	iconv -f iso-8859-1 -t utf-8 -o ${f}.utf8 ${f}
	mv -f ${f}.utf8 ${f}
done

rm -rf \
  3rdparty/cppunit \
  3rdparty/sqlite3 \
  #

%build
# FIXME: tests got linking problems with lcc 1.23.20, cf. mcst#3675?
%cmake \
%ifarch %e2k
	-DENABLE_TESTS:BOOL=OFF \
%endif
  -DCMAKE_BUILD_TYPE=Release \
  -DFG_DATA_DIR=%_datadir/flightgear \
  -DSYSTEM_CPPUNIT=ON \
  -DSYSTEM_SQLITE=ON \
  #
%cmake_build

%install
%cmakeinstall_std

rm -rf %buildroot%_datadir/locale
rm -rf %buildroot%_datadir/bash-completion/ %buildroot%_datadir/zsh/

%files
%_bindir/*
%_mandir/*/*
%_iconsdir/*/*/*/flightgear.*
%_desktopdir/org.flightgear.FlightGear.desktop
%_datadir/metainfo/*.xml

%changelog
