%define _unpackaged_files_terminate_build 1

Name: FlightGear-data
Version: 2024.1.1
Release: alt1

Summary: Data pack for FlightGear flight simulator
License: GPL-2.0-or-later
Group: Games/Arcade

Url: http://www.flightgear.org
# Source-url: https://sourceforge.net/projects/flightgear/files/release-2020.3/FlightGear-%version-data.txz/download
Source: %name-%version.tar
# NB: ignore *-update-data.txz, it's just a diff (better rely on a full version)

BuildArch: noarch
AutoReqProv: no

Provides: fgfs-data = %version-%release
# to avoid data lurking w/o binaries
# NB: release intentionally left out
Requires: FlightGear = %version

# it's more than two gigs of data
%brp_strip_none
%set_fixup_method skip
#set_strip_method none
%set_cleanup_method skip
%set_compress_method none
%set_verify_elf_method skip

%description
FlightGear is a sophisticated flight simulator framework for the
development and pursuit of interesting flight simulator ideas.

This package contains base FlightGear data files.

%package -n FlightGear-doc
Summary: Documentation for FlightGear flight simulator
Group: Books/Computer books

%description -n FlightGear-doc
FlightGear is a sophisticated flight simulator framework for the
development and pursuit of interesting flight simulator ideas.

This package contains FlightGear documentation.

%prep
%setup

%install
mkdir -p %buildroot{%_datadir/flightgear,%_docdir}
mv Docs %buildroot%_docdir/FlightGear-%version
mv AUTHORS ChangeLog NEWS README %buildroot%_docdir/FlightGear-%version/
mv * %buildroot%_datadir/flightgear/

# It is the file in the package named Thumbs.db or Thumbs.db.gz,
# which is normally a Windows image thumbnail database.
# Such databases are generally useless in packages and were usually
# accidentally included by copying complete directories from the source tarball.
find %buildroot -name 'Thumbs.db*' -print -delete

%files
%_datadir/flightgear/

%files -n FlightGear-doc
%_docdir/FlightGear-%version

%changelog
