%def_without clang
%def_disable qt4
%def_enable qt5
%def_with kf6

Name: Kvantum
Version: 1.1.4
Release: alt1

Summary: SVG-based theme engine for Qt6, KDE and LXQt
License: GPL-3.0-or-later
Group: Graphical desktop/Other

Url: https://github.com/tsujan/Kvantum
Vcs: git://github.com/tsujan/Kvantum.git
# Source-url: https://github.com/tsujan/Kvantum/archive/V%%version.tar.gz
Source: %name-%version.tar.gz
Packager: Leontiy Volodin <lvol@altlinux.org>

BuildPreReq: rpm-build-ninja desktop-file-utils rpm-macros-qt6
BuildRequires: cmake qt6-svg-devel qt6-tools-devel

%if_with clang
BuildRequires: clang-devel lld-devel
%else
BuildRequires: gcc-c++
%endif

%if_enabled qt4
BuildPreReq: rpm-macros-qt4
BuildRequires: libqt4-devel
%endif

%if_enabled qt5
BuildPreReq: rpm-macros-qt5
BuildRequires: qt5-svg-devel qt5-x11extras-devel
Requires: %name-qt5
%endif

%if_with kf6
BuildRequires: kf6-kwindowsystem-devel
%endif

Requires: %name-data %name-qt6

%description
Kvantum is an SVG-based theme engine for Qt6, KDE and LXQt, with an emphasis
on elegance, usability and practicality.

Kvantum has a default dark theme, which is inspired by the default theme of
Enlightenment. Creation of realistic themes like that for KDE was the first
reason to make Kvantum but it goes far beyond its default theme: you could
make themes with very different looks and feels for it, whether they be
photorealistic or cartoonish, 3D or flat, embellished or minimalistic, or
something in between, and Kvantum will let you control almost every aspect of
Qt widgets.

Kvantum also comes with extra themes that are installed as root with Qt6
installation and can be selected and activated by using Kvantum Manager.

%package data
Summary: SVG-based theme engine for Qt6, KDE and LXQt
Group: Graphical desktop/Other
BuildArch: noarch

%description data
Kvantum is an SVG-based theme engine for Qt6, KDE and LXQt, with an emphasis
on elegance, usability and practicality.

This package contains the data needed for Kvantum.

%if_enabled qt4
%package qt4
Summary: Qt4 plugins for %name
Group: Graphical desktop/Other

%description qt4
This packages provides qt4 plugins for %name.
%endif

%if_enabled qt5
%package qt5
Summary: Qt5 plugins for %name
Group: Graphical desktop/Other

%description qt5
This packages provides qt5 plugins for %name.
%endif

%package qt6
Summary: Qt6 plugins for %name
Group: Graphical desktop/Other

%description qt6
This packages provides qt6 plugins for %name.

%prep
%setup

%build
export LC_ALL=C.UTF-8
%if_with clang
%define optflags_lto -flto=thin
export CC=clang
export CXX=clang++
export LDFLAGS="-fuse-ld=lld $LDFLAGS"
%endif

%ifarch %e2k
# -std=c++03 by default as of lcc 1.23.12
%add_optflags -std=c++11
%endif

%if_enabled qt4
%cmake -B build4 \
 -GNinja \
 -DCMAKE_BUILD_TYPE=RelWithDebInfo \
 -DENABLE_QT4=ON \
#
cmake --build "build4" -j%__nprocs
%endif

%if_enabled qt5
%cmake -B build5 \
 -GNinja \
 -DCMAKE_BUILD_TYPE=RelWithDebInfo \
 -DENABLE_QT5=ON \
#
cmake --build "build5" -j%__nprocs
%endif

%cmake -B build6 \
 -GNinja \
 -DCMAKE_BUILD_TYPE=RelWithDebInfo \
%if_without kf6
 -DWITHOUT_KF=ON \
%endif
#
cmake --build "build6" -j%__nprocs

%install
export DESTDIR="%buildroot"
%if_enabled qt4
cmake --install "build4/style" --verbose
%endif
%if_enabled qt5
cmake --install "build5/style" --verbose
%endif
cmake --install "build6" --verbose

# desktop-file-validate doesn't recognize LXQt
sed -i "s|LXQt|X-LXQt|" %buildroot%_desktopdir/kvantummanager.desktop
desktop-file-validate %buildroot%_desktopdir/kvantummanager.desktop

%find_lang %name --all-name --with-qt

%files
%doc COPYING
%doc ChangeLog NEWS README.md
%_bindir/kvantummanager
%_bindir/kvantumpreview

%files data -f %name.lang
%_datadir/Kvantum
%_desktopdir/kvantummanager.desktop
%dir %_datadir/kvantummanager
%dir %_datadir/kvantummanager/translations
%_datadir/kvantummanager/translations/kvantummanager_zh_Hant.qm
%dir %_datadir/kvantumpreview
%dir %_datadir/kvantumpreview/translations
%_datadir/kvantumpreview/translations/kvantumpreview_zh_Hant.qm
%dir %_datadir/color-schemes
%_datadir/color-schemes/Kv*
%dir %_iconsdir/hicolor/scalable
%dir %_iconsdir/hicolor/scalable/apps
%_iconsdir/hicolor/scalable/apps/kvantum.svg

%if_enabled qt4
%files qt4
%_qt4dir/plugins/styles/libkvantum.so
%endif

%if_enabled qt5
%files qt5
%_qt5_plugindir/styles/libkvantum.so
%endif

%files qt6
%_qt6_plugindir/styles/libkvantum.so

%changelog
