%define nm_version 1.46.2

%def_with gtk4

%define _unpackaged_files_terminate_build 1

%ifarch %e2k
%define more_warnings no
%else
%define more_warnings error
%endif

Name: NetworkManager-openvpn
Version: 1.12.3
Release: alt1
License: GPLv2+
Group: System/Configuration/Networking
Summary: NetworkManager VPN plugin for OpenVPN
Url: https://networkmanager.dev/docs/vpn/
Vcs: https://gitlab.gnome.org/GNOME/NetworkManager-openvpn.git
Source0: %name-%version.tar
Patch: %name-%version-%release.patch

BuildRequires: gettext
BuildRequires: libnm-devel >= %nm_version
BuildRequires: libnma-devel
BuildRequires: libgtk+3-devel
BuildRequires: libsecret-devel
%{?_with_gtk4:BuildRequires: libgtk4-devel >= 4.6.3 libnma-gtk4-devel}

Requires: NetworkManager-daemon   >= %nm_version
Requires: openvpn          >= 2.1

%description
NetworkManager-openvpn provides VPN support to NetworkManager for
OpenVPN.

%package gtk-common
License: GPLv2+
Summary: Common part of %name GTK support
Group: Graphical desktop/GNOME
Requires: NetworkManager-openvpn = %version-%release

%description gtk-common
This package contains common part for %name GTK support.

%package gtk3
License: GPLv2+
Summary: Files for GTK3 applications to use %name
Group: Graphical desktop/GNOME
Requires: %name-gtk-common = %version-%release

Obsoletes: %name-gnome < 0.9.8.4
Provides: %name-gnome = %version-%release

Obsoletes: %name-gtk < 1.8.18-alt1
Provides: %name-gtk = %version-%release

%description gtk3
This package contains files for GTK3 applications to use %name.

%if_with gtk4
%package gtk4
License: GPLv2+
Summary: Files for GTK4 applications to use %name
Group: Graphical desktop/GNOME
Requires: %name-gtk-common = %version-%release

%description gtk4
This package contains files for GTK4 applications to use %name.
%endif

%prep
%setup
%patch -p1

%build
%autoreconf
%configure \
	--disable-static \
	--libexecdir=%_libexecdir/NetworkManager \
	--localstatedir=%_var \
	%{subst_with gtk4} \
	--disable-silent-rules \
	--enable-more-warnings=%more_warnings
%make_build

%install
%makeinstall_std
%find_lang %name

%check
make check

%files
%doc AUTHORS README
%_libexecdir/NetworkManager/nm-openvpn-service
%_libexecdir/NetworkManager/nm-openvpn-service-openvpn-helper
%_libdir/NetworkManager/libnm-vpn-plugin-openvpn.so
%config %_datadir/dbus-1/system.d/nm-openvpn-service.conf
%config %_libexecdir/NetworkManager/VPN/nm-openvpn-service.name

%files gtk-common -f %name.lang
%_libexecdir/NetworkManager/nm-openvpn-auth-dialog
%_datadir/metainfo/*.xml

%files gtk3
%_libdir/NetworkManager/libnm-vpn-plugin-openvpn-editor.so

%if_with gtk4
%files gtk4
%_libdir/NetworkManager/libnm-gtk4-vpn-plugin-openvpn-editor.so
%endif

%exclude %_libdir/NetworkManager/*.la

%changelog
