%def_disable static

Name: SDL_sound
Version: 1.0.3
Release: alt6.git4a8ecd7
%define lib_name lib%name

Summary: An abstract soundfile decoder
License: LGPL-2.1+
Group: System/Libraries
URL: http://icculus.org/SDL_sound/
# hg clone http://hg.icculus.org/icculus/SDL_sound/
Source: %name-%version.tar
Patch: SDL_sound-1.0.3-debian-libphysfs.patch

BuildRequires: doxygen libSDL-devel libflac-devel libmikmod-devel libmodplug-devel libspeex-devel libvorbis-devel libphysfs-devel
%ifnarch %arm
BuildRequires: libsmpeg-devel
%endif

%package -n %lib_name
Summary: An abstract soundfile decoder
Group: System/Libraries
Provides: %name = %version-%release

%package -n %lib_name-devel
Summary: Header files and more to develop SDL_sound applications
Group: Development/C
Requires: %lib_name = %version-%release
Provides: %name-devel = %version-%release

%if_enabled static
%package -n %lib_name-devel-static
Summary: Static libraries for develop SDL_sound applications
Group: Development/C
Requires: %lib_name-devel = %version-%release
%endif

%description
SDL_sound is a library that handles the decoding of several popular
sound file formats, such as .WAV and .MP3.  It is meant to make
the programmer's sound playback tasks simpler.  The programmer
gives SDL_sound a filename, or feeds it data directly from one of
many sources, and then reads the decoded waveform data back at her
leisure.  If resource constraints are a concern, SDL_sound can process
sound data in programmer-specified blocks.  Alternately, SDL_sound
can decode a whole sound file and hand back a single pointer to the
whole waveform.  SDL_sound can also handle sample rate, audio format,
and channel conversion on-the-fly and behind-the-scenes, if the
programmer desires.

%description -n %lib_name
SDL_sound is a library that handles the decoding of several popular
sound file formats, such as .WAV and .MP3.  It is meant to make
the programmer's sound playback tasks simpler.  The programmer
gives SDL_sound a filename, or feeds it data directly from one of
many sources, and then reads the decoded waveform data back at her
leisure.  If resource constraints are a concern, SDL_sound can process
sound data in programmer-specified blocks.  Alternately, SDL_sound
can decode a whole sound file and hand back a single pointer to the
whole waveform.  SDL_sound can also handle sample rate, audio format,
and channel conversion on-the-fly and behind-the-scenes, if the
programmer desires.

%description -n %lib_name-devel
Header files and more to develop SDL_sound applications.

%if_enabled static
%description -n %lib_name-devel-static
Static library for develop SDL_sound applications.
%endif

%prep
%setup
%patch -p1
cp -a ./CHANGELOG.txt ./ChangeLog
cp -a ./CREDITS.txt ./AUTHORS
cp -a ./README.txt ./README
cp -a ./CHANGELOG.txt ./NEWS

%build
%add_optflags -I%_includedir/smpeg
%add_optflags -L/%_lib -lm
%autoreconf
%configure

%make_build
doxygen

%install
%makeinstall_std
mkdir -p %buildroot%_man3dir
cp -a docs/man/man3/* %buildroot%_man3dir/
pushd %buildroot%_man3dir
mv actual.3 Sound_Sample::actual.3
mv author.3 Sound_DecoderInfo::author.3
mv buffer.3 Sound_Sample::buffer.3
mv buffer_size.3 Sound_Sameple::buffer_size.3
mv channels.3 Sound_AudioInfo::channels.3
mv decoder.3 Sound_Sample::decoder.3
mv description.3 Sound_DecoderInfo::description.3
mv desired.3 Sound_Sample::desired.3
mv extensions.3 Sound_DecoderInfo::extensions.3
mv flags.3 Sound_Sample::flags.3
mv format.3 Sound_AudioInfo::format.3
mv major.3 Sound_Version::major.3
mv minor.3 Sound_Version::minor.3
mv opaque.3 Sound_Sample::opaque.3
mv patch.3 Sound_Version::patch.3
mv rate.3 Sound_AudioInfo::rate.3
mv url.3 Sound_DecoderInfo::url.3
popd

%define docdir %_docdir/%name-%version
mkdir -p %buildroot%docdir
cp -a *.txt docs/html %buildroot%docdir/

%if_disabled static
rm -f %buildroot%_libdir/*.a
%endif

%files -n %lib_name
%_bindir/*
%_libdir/*.so.*
%docdir
%exclude %docdir/html

%files -n %lib_name-devel
%_libdir/*.so
%_includedir/*
%_man3dir/*
%dir %docdir
%docdir/html

%if_enabled static
%files -n %lib_name-devel-static
%_libdir/*.a
%endif

%changelog
