%def_enable check
%define _localstatedir %_var
%define _libexecdir %_prefix/libexec

Name: accountsservice
Version: 23.13.9
Release: alt5
Summary: D-Bus interfaces for querying and manipulating user account information

Group: System/Base
License: GPLv3+
Url: https://www.freedesktop.org/wiki/Software/AccountsService/
Vcs: https://gitlab.freedesktop.org/accountsservice/accountsservice.git

Source: %name-%version.tar
Patch1: %name-%version.patch

BuildRequires: meson >= 0.63.0
BuildRequires: gtk-doc
BuildRequires: pkgconfig(gio-2.0) >= 2.63.5
BuildRequires: pkgconfig(gio-unix-2.0)
BuildRequires: pkgconfig(glib-2.0) >= 2.63.5
BuildRequires: pkgconfig(polkit-gobject-1)
BuildRequires: pkgconfig(dbus-1)
BuildRequires: gobject-introspection-devel
BuildRequires: vala-tools
BuildRequires: libsystemd-devel >= 186 systemd-devel
# for test
%if_enabled check
BuildRequires: python3-module-pygobject3 python3-module-dbusmock
BuildRequires: /proc
%endif

Requires: polkit
Requires: shadow-utils
Requires: lib%name = %version-%release

%package -n lib%name
Summary: Client-side library to talk to accountservice
Group: System/Libraries

%description -n lib%name
The libaccountsservice package contains a library that can
be used by applications that want to interact with the accountsservice
daemon.

%package -n lib%name-devel
Summary: Development files for accountsservice
Group: Development/Other
Requires: lib%name = %version-%release

%description -n lib%name-devel
The libaccountsservice-devel package contains headers and other
files needed to build applications that use accountsservice.

%description
The accountsservice project provides a set of D-Bus interfaces for
querying and manipulating user account information and an implementation
of these interfaces, based on the useradd, usermod and userdel commands.

%package -n lib%name-gir
Summary: GObject introspection data for the accountsservice library
Group: System/Libraries
Requires: lib%name = %version-%release

%description -n lib%name-gir
GObject introspection data for the accountsservice library

%package -n lib%name-gir-devel
Summary: GObject introspection devel data for the accountsservice library
Group: Development/Other
BuildArch: noarch
Requires: lib%name-devel = %version-%release lib%name-gir = %version-%release

%description -n lib%name-gir-devel
GObject introspection devel data for the accountsservice library

%prep
%setup
%patch1 -p1

%build
%meson \
    -Dadmin_group=wheel \
    -Dextra_admin_groups="adm,netadmin" \
    -Ddefault_user_groups="audio,video,camera,scanner,cdrom,cdwriter,fuse,users,usershares,uucp,xgrp" \
    -Dsystemdsystemunitdir=%_unitdir
%meson_build

%install
%meson_install
# Install empty directory for interfaces
mkdir -p %buildroot%_datadir/%name/interfaces
%find_lang accounts-service

%check
%meson_test

%files -f accounts-service.lang
%doc COPYING README.md AUTHORS
%_libexecdir/accounts-daemon
%_datadir/dbus-1/system.d/org.freedesktop.Accounts.conf
%_datadir/dbus-1/system-services/org.freedesktop.Accounts.service
%_datadir/polkit-1/actions/org.freedesktop.accounts.policy
%dir %_localstatedir/lib/AccountsService/
%attr(700,root,root) %dir %_localstatedir/lib/AccountsService/users
%attr(775,root,root) %dir %_localstatedir/lib/AccountsService/icons
%_datadir/%name
%_unitdir/accounts-daemon.service

%files -n lib%name
%_libdir/*.so.*

%files -n lib%name-gir
%_typelibdir/*.typelib

%files -n lib%name-devel
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/*.pc
%_datadir/dbus-1/interfaces/*.xml
%_datadir/vala/vapi/%name.deps
%_datadir/vala/vapi/%name.vapi

%files -n lib%name-gir-devel
%_girdir/*.gir

%changelog
