%define basever 1.1.0

Name: alsa-tools
Version: 1.2.5
Release: alt2

Summary: Advanced Linux Sound Architecture (ALSA) tools
License: GPLv2+
Group: System/Kernel and hardware

Url: http://www.alsa-project.org/
Source0: %name-%version.tar
Source1: 90-alsa-tools-firmware.rules
Patch: %name-%version-%release.patch
Packager: Valery Inozemtsev <shrek@altlinux.ru>

Obsoletes: hda-verb < 0.4
Obsoletes: alsa2-tools < 0.9.4
Provides: alsa2-tools = %version
Requires: libalsa >= %basever
# echomixer
Requires: fonts-bitmap-misc
# due to %%_bindir/as10k1
Conflicts: emu10k1-tools
# someone remind me how to cheat SourceIfExists clones
Provides: /etc/default/ld10k1

BuildRequires: gcc-c++ libgtk+2-devel libgtk+3-devel
BuildRequires: libalsa-devel >= %basever
BuildRequires: rpm-build-python3

%define udevdir /lib/udev

Summary(ru_RU.UTF-8): Инструменты ALSA
Summary(uk_UA.UTF-8): Інструменти ALSA

%description
Advanced Linux Sound Architecture (ALSA) tools. Modularized architecture
with support for a large range of ISA and PCI cards. Fully compatible
with OSS/Lite but contains many enhanced features.

You may install this package if you really want use this low-level utils
with some audio cards.

%description -l ru_RU.UTF-8
Пакет содержит инструменты ALSA (современной звуковой подсистемы Linux),
предназначенные для низкоуровневой работы с некоторыми звуковыми картами
(на чипах Envy24, EMU10K1).

%description -l uk_UA.UTF-8
Пакунок містить інструменти ALSA (сучасної звукової підсистеми Linux),
що застосовуються для низькорівневої роботи із деякими звуковими
картками (на чіпах Envy24, EMU10K1).

%package -n hwmixvolume
Summary: Control individual streams volume on hardware-mixing soundcards
Group: System/Kernel and hardware
BuildArch: noarch

%description -n hwmixvolume
This tool allows you to control the volume of individual streams
on sound cards that use hardware mixing, i.e., those based on the
following chips:
* Creative Emu10k1 (SoundBlaster Live!) (driver: snd-emu10k1)
* VIA VT823x southbridge (driver: snd-via82xx)
* Yamaha DS-1 (YMF-724/740/744/754) (driver: snd-ymfpci)

It is recommended to use at least Linux kernel 2.6.32
or alsa-driver 1.0.22; otherwise, the name of the program
that is using a stream cannot be shown.

%package -n hdajackretask
Summary: ALSA soundcard jack task manipulation tool
Group: System/Kernel and hardware

%description -n hdajackretask
Most HDA Intel soundcards are to some degree retaskable, i.e. can
be used for more than one thing. This tool is a GUI to make it
easy to retask your jacks - e g, turn your Mic jack into an extra
Headphone, or why not make them both line outs and connect them
to your surround receiver?

%package -n ld10k1
Summary: EMU10K1 patch loader/linker
Group: System/Kernel and hardware

%description -n ld10k1
EMU10K1 patch loader/linker, see also as10k1

%package -n liblo10k1
Summary: lo10k1 library
Group: System/Libraries

%description -n liblo10k1
lo10k1 library

%package -n liblo10k1-devel
Summary: lo10k1 library, development part
Group: Development/C

%description -n liblo10k1-devel
lo10k1 library, development part

%prep
%setup
%patch -p1

sed -E -i '1 s@^(#![[:space:]]*)%_bindir/(env[[:space:]]+)?python\>@\1%__python3@' hwmixvolume/hwmixvolume

mv seq/sbiload sbiload
rm -rf {seq,hdsp*,qlo10k1}

%build
export PATH=$PATH:$(pwd)/as10k1
for d in *; do
	if [ -d $d ]; then
		cd $d
		%autoreconf
		%configure
		%make_build
		cd ..
	fi
done

%install
for d in *; do
	if [ -d $d ]; then
		cd $d
		%makeinstall_std
		cd ..
	fi
done

# convert hotplug stuff to udev
rm -f %buildroot%_sysconfdir/hotplug/usb/tascam_fw.usermap
mkdir -p %buildroot{%udevdir,%_udevrulesdir}
mv %buildroot%_sysconfdir/hotplug/usb/* %buildroot%udevdir/
install -pm644 %SOURCE1 %buildroot%_udevrulesdir/

%files
%exclude %_bindir/hdajackretask
%exclude %_bindir/hwmixvolume
%exclude %_bindir/lo10k1
%_bindir/*
%_datadir/sounds/opl3
%_man1dir/*
%_udevrulesdir/*.rules
%udevdir/tascam_fpga
%udevdir/tascam_fw

%files -n hdajackretask
%_bindir/hdajackretask

%files -n hwmixvolume
%_bindir/hwmixvolume

%files -n ld10k1
%_bindir/lo10k1
%_sbindir/*
%_datadir/ld10k1

%files -n liblo10k1
%_libdir/liblo10k1.so.*

%files -n liblo10k1-devel
%_includedir/lo10k1
%_libdir/liblo10k1.so
%_datadir/aclocal/ld10k1.m4

# TODO:
# - consider http://cvs.fedoraproject.org/viewvc/rpms/alsa-tools/devel/

%changelog
