%define _unpackaged_files_terminate_build 1

Name: alt-components-base
Version: 0.9.4
Release: alt1

Summary: Base set of ALT Distributions components
License: GPLv2+
Group: System/Configuration/Other
URL: https://altlinux.space/alterator/alt-components-base

BuildArch: noarch

Source0: %name-%version.tar

BuildRequires: cmark
BuildRequires: autoconf-common
BuildRequires: alterator-entry >= 0.4.4
BuildRequires(pre): rpm-macros-alterator

Provides: alterator-components-base = 0.1.5
Obsoletes: alterator-components-base < 0.2.0

%description
%summary.

%package -n alt-editions-server
Summary: Editions of BaseALT distribution ALT Server
Group: System/Configuration/Other

Requires: alt-components-base = %version-%release

%description -n alt-editions-server
%summary.

%package -n alt-editions-education
Summary: Editions of BaseALT distribution ALT Education
Group: System/Configuration/Other

Requires: alt-components-base = %version-%release

%description -n alt-editions-education
%summary.

%package -n alt-components-vendors
Summary: Vendors set of ALT Distributions components
Group: System/Configuration/Other

Requires: alt-components-base = %version-%release

%description -n alt-components-vendors
%summary.

%prep
%setup

%build
for d in components/*/ vendors/*/*/ categories/* ; do
    find "$d" -type f -name "description*.md" -print0 | while IFS= read -r -d '' file; do
        cmark "$file" > "${file/%%md/html}"
    done
done

cd editions
autoconf
./configure

%install
# install Components
mkdir -p "%buildroot%_alterator_datadir/components/categories"

rm -f install.base_components.list install.vendors_components.list vendors_categories.list
touch install.base_components.list install.vendors_components.list vendors_categories.list

for d in categories/*/ ; do
    d="$(basename "$d")"
    f="categories/$d/$d.category"
    c="$(alterator-entry get "$f" category ||:)"

    mkdir -p "%buildroot%_alterator_datadir/components/categories/$d"
    install -v -p -m 644 -D "$f" "%buildroot%_alterator_datadir/components/categories/$d/"

    find "categories/$d" -type f -name "description*.html" -print0 | while IFS= read -r -d '' file; do
        install -v -p -m 644 -D "$file" "%buildroot%_alterator_datadir/components/categories/$d"
    done

    if [ "$c" != "vendors" ]; then
        echo "%_alterator_datadir/components/categories/$d" >>install.base_components.list
    else
        echo "%_alterator_datadir/components/categories/$d" >>install.vendors_components.list
        echo "$(alterator-entry get "$f" name)" >>vendors_categories.list
    fi
done

for d in components/*/ vendors/*/*/ ; do
    dd="$(dirname "$d")"
    d="$(basename "$d")"
    f="$dd/$d/$d.component"
    c="$(alterator-entry get "$f" category)"

    mkdir -p "%buildroot%_alterator_datadir/components/$d"
    install -v -p -m 644 -D "$f" "%buildroot%_alterator_datadir/components/$d"

    find "$dd/$d" -name '*.png' -type f | while read -r file; do
        install -v -p -m 664 -D "$file" "%buildroot%_alterator_datadir/components/$d"
    done

    find "$dd/$d" -type f -name "description*.html" -print0 | while IFS= read -r -d '' file; do
        install -v -p -m 644 -D "$file" "%buildroot%_alterator_datadir/components/$d"
    done

    if grep -q "^$c$" vendors_categories.list; then
        echo "%_alterator_datadir/components/$d" >>install.vendors_components.list
    else
        echo "%_alterator_datadir/components/$d" >>install.base_components.list
    fi
done

# install Editions
mkdir -p "%buildroot%_alterator_datadir/editions"

for d in editions/edition_*/ ; do
    find "$d" -type f -name "description*.md" -print0 | while IFS= read -r -d '' file; do
        cmark "$file" > "${file/%%md/html}"
    done
done

for edition_dir in editions/edition_*/; do
    edition="$(basename "$edition_dir")"

    mkdir -p "%buildroot%_alterator_datadir/editions/$edition"

    install -v -p -m 644 -D "$edition_dir/$edition.edition" "%buildroot%_alterator_datadir/editions/$edition"

    find "$edition_dir" -type f -name "*.html" -print0 | while IFS= read -r -d '' file; do
        install -v -p -m 644 -D "$file" "%buildroot%_alterator_datadir/editions/$edition"
    done
done

%check
# check Components and Editions
./scripts/validate_categories.py

%files -f install.base_components.list
%dir %_alterator_datadir/components
%dir %_alterator_datadir/components/categories

%files -n alt-components-vendors -f install.vendors_components.list

%files -n alt-editions-server
%dir %_alterator_datadir/editions
%_alterator_datadir/editions/edition_server
%_alterator_datadir/editions/edition_domain

%files -n alt-editions-education
%dir %_alterator_datadir/editions
%_alterator_datadir/editions/edition_education

%changelog
