%define rname alt-customize-branding

Name: %rname
Version: 1.2.0
Release: alt2
%K6init no_altplace

#Group: Graphics
Group: Graphical desktop/Other
Summary: Customize branding tool
License: GPL-3.0-or-later
Url: https://www.basealt.ru/
Source: %rname-%version.tar

ExcludeArch: armh

Requires: qt6-translations convert
Requires: %rname-backend
Requires: libkf6authcore

BuildRequires(pre): rpm-build-kf6

BuildRequires: extra-cmake-modules 
BuildRequires: qt6-declarative-devel
BuildRequires: qt6-tools
BuildRequires: libImageMagick-devel
BuildRequires: kf6-kcmutils-devel 
BuildRequires: kf6-ki18n-devel
BuildRequires: kf6-kio-devel
BuildRequires: kf6-kwindowsystem-devel
BuildRequires: kf6-kconfig-devel
BuildRequires: kf6-kio-devel

%description
The ALT tool to customize branding

%package backend
Summary: Customize branding tool backend
License: GPL-3.0-or-later
Group: System/Configuration/Boot and Init
%description backend
The ALT tool backend for KDE to customize branding

%prep
%setup -n %rname-%version

%build
%K6build \
    -DQT_MAJOR_VERSION=6 \
    #
lrelease-qt6 translations/alt-customize-branding_ru_RU.ts

%install
%K6install

# translations
mkdir -p %buildroot/%_qt6_translationdir/
install -m 0644 translations/*.qm %buildroot/%_qt6_translationdir/

# branding_helper script
mkdir -p %buildroot/%_K6libexecdir/kauth/
install -m 0755 altcusbranding_helper_script %buildroot/%_K6libexecdir/kauth/

# alt-customize-branding-settings.ini
mkdir -p %buildroot%_localstatedir/%rname
#install -m 0644 %%rname-settings.ini %%buildroot%%_localstatedir/%%rname/

# alternatives
mkdir -p %buildroot%_altdir
install -m 0644 %rname %buildroot%_altdir/

# branding directories
mkdir -p %buildroot/boot/grub/themes/%rname
mkdir -p %buildroot%_datadir/design/%rname
mkdir -p %buildroot%_datadir/plymouth/themes/%rname

%find_lang --with-qt --all-name %rname

%postun backend
if [ $1 -eq 0 ] ; then
    %define configFile alt-customize-branding-settings.ini
    %define configDir /var/lib
    if [ -f %configDir/%rname/%configFile ] ; then
        previousThemeName=$(awk -F "=" '/ThemeName/ {print $2}' %configDir/%rname/%configFile)
        echo Previous theme name: $previousThemeName
# Change /etc/sysconfig/grub2 and run
        . shell-config
        shell_config_set /etc/sysconfig/grub2 GRUB_THEME /boot/grub/themes/$previousThemeName/theme.txt
        shell_config_set /etc/sysconfig/grub2 GRUB_BACKGROUND /boot/grub/themes/$previousThemeName/grub.png
# generate file "/boot/grub/grub.cfg"
        /usr/sbin/grub-mkconfig -o /boot/grub/grub.cfg
# Change theme name in file 'plymouthd.conf':
        [ -f "/etc/plymouth/plymouthd.conf" ] && sed -i "s/Theme=.*/Theme=$previousThemeName/" /etc/plymouth/plymouthd.conf || :
    fi
# Remove directories
#rm -R %%_localstatedir/%%rname
    if [ -d "/usr/share/design/%rname" ]; then
        rm -R /usr/share/design/%rname
    fi
    if [ -d "/boot/grub/themes/%rname" ]; then
        rm -R /boot/grub/themes/%rname
    fi
    if [ -d "/usr/share/plymouth/themes/%rname" ]; then
        rm -R /usr/share/plymouth/themes/%rname
    fi
    if [ -d "/tmp/%rname" ]; then
        rm -R /tmp/%rname
    fi
# Toggle/repair alternatives
    alternatives-update
    currentBranding=`basename $(readlink -nf /usr/share/design/current)`
    [ "$currentBranding" = "%rname" ] && make-initrd || :
fi

%files -f %rname.lang
%_K6bin/*
%_K6xdgapp/%rname.desktop
%_K6exec/kauth/altcusbranding_helper
%_K6dbus/system.d/org.kde.altcusbranding.conf
%_K6dbus_sys_srv/org.kde.altcusbranding.service
%_datadir/polkit-1/actions/org.kde.altcusbranding.policy
%doc COPYING

%files backend
%_K6libexecdir/kauth/altcusbranding_helper_script
%_altdir/%rname
%_localstatedir/%rname
%_datadir/design/%rname
%_datadir/plymouth/themes/%rname
/boot/grub/themes/%rname

#%%_qt6_translationdir/alt-customize-branding_ru_RU.qm
#%%doc README

%changelog
