%define _name alt-panelmode
%define xdg_name org.altlinux.%_name

Name: alt-panelmoded
Version: 0.6.1
Release: alt1

Summary: Used for panelmode on Alt operating systems with GNOME
License: GPL-3.0-or-later
Group: Graphical desktop/GNOME

Url: https://gitlab.gnome.org/Armatik/alt-panelmoded
Vcs: https://gitlab.gnome.org/Armatik/alt-panelmoded
Source: %name-%version.tar

BuildRequires(pre): rpm-macros-meson
BuildRequires: meson
BuildRequires: vala
BuildRequires: pkgconfig(gio-2.0)
BuildRequires: pkgconfig(gee-0.8)

Requires: dconf
Requires: gnome-shell-extensions
Requires: gnome-shell-extension-dash-to-panel
Requires: gnome-shell-extension-arcmenu
Requires: gnome-shell-extension-gtk4-desktop-icons-ng
Requires: gnome-shell-extension-appindicator
Requires: gnome-shell-extension-clipboard-indicator

%description
Used for panelmode on operating systems of the Alt family
with GNOME desktop enviroment.

%prep
%setup

%build
%meson
%meson_build

%install
%meson_install
%find_lang --with-gnome %_name

%files -f %_name.lang
%_bindir/%_name
%_datadir/dbus-1/services/%xdg_name.service
%_datadir/glib-2.0/schemas/%xdg_name.gschema.xml

%changelog
