%define _unpackaged_files_terminate_build 1

%define files_alterator_interface() \
%dir %_datadir/dbus-1 \
%dir %_datadir/dbus-1/interfaces \
%dir %_datadir/polkit-1 \
%dir %_datadir/polkit-1/actions \
%_datadir/dbus-1/interfaces/*.%{1}.xml \
%_datadir/polkit-1/actions/*.%{1}.policy

%define files_alterator_backend() \
%dir %_alterator_datadir \
%dir %_alterator_datadir/objects \
%dir %_alterator_datadir/backends \
%_alterator_datadir/objects/%{1}.object \
%_alterator_datadir/backends/%{1}.backend

%define files_alterator_application() \
%dir %_alterator_datadir \
%dir %_alterator_datadir/backends \
%dir %_alterator_datadir/applications \
%_alterator_datadir/backends/%{1}-app.backend \
%_alterator_datadir/applications/%{1}.application

Name: alt-systeminfo
Version: 0.4.6
Release: alt1

Summary: ALT Systeminfo - Alterator application that shows information about system
License: GPLv2+
Group: System/Configuration/Other
URL: https://altlinux.space/alterator/alt-systeminfo

Source: %name-%version.tar

Requires: alterator-interface-application >= 0.1.1
Requires: alterator-backend-systeminfo >= 0.3.2
Requires: alterator-module-executor >= 0.1.19
# Recommends: alterator-backend-edition >= 0.1.5
# Recommends: alterator-backend-packages >= 0.1.4

BuildRequires(pre): rpm-macros-alterator
BuildRequires(pre): rpm-macros-cmake
BuildRequires: cmake
BuildRequires: cmake-modules
BuildRequires: gcc-c++
BuildRequires: qt6-base-common qt6-base-devel qt6-tools-devel
BuildRequires: libtomlplusplus-devel

Provides: alterator-interface-release_notes = %version-%release
Provides: alterator-backend-release_notes = %version-%release
Provides: alterator-application-release_notes = %version-%release
Provides: alterator-interface-license = %version-%release
Provides: alterator-backend-license = %version-%release
Provides: alterator-application-license = %version-%release
Provides: alterator-application-systeminfo = %version-%release

Obsoletes: alterator-interface-release_notes < 0.4.4-alt2
Obsoletes: alterator-backend-release_notes < 0.4.4-alt2
Obsoletes: alterator-application-release_notes < 0.4.4-alt2
Obsoletes: alterator-interface-license < 0.4.4-alt2
Obsoletes: alterator-backend-license < 0.4.4-alt2
Obsoletes: alterator-application-license < 0.4.4-alt2
Obsoletes: alterator-application-systeminfo < 0.4.5-alt3

%description
ALT Systeminfo - Alterator application that shows information about system.

%prep
%setup

%build
%cmake
%cmake_build

%install
%cmakeinstall_std

%files
%files_alterator_application systeminfo
%_desktopdir/*
%_bindir/*
%doc LICENSE CHANGELOG.md

%files_alterator_interface release_notes1
%files_alterator_backend release-notes
%files_alterator_application release-notes
%files_alterator_interface license1
%files_alterator_backend license
%files_alterator_application license

%changelog
