%define sort_filter_proxy_model_commit f2881493e42bd7b7d5b7abe804dad084dd610b71
%define qtkeychain_commit 7460df6a978669290de5b56c2d98b199b61c3f88
%define qsimplecrypto_commit c99b33f0e08b7206116ddff85c22d3b97ce1e79d

Name: amnezia-vpn
Version: 4.8.9.2
Release: alt1

Summary: The best client for self-hosted VPN
License: GPL-3.0
Group: System/Servers

Url: https://amnezia.org/
Packager: Nazarov Denis <nenderus@altlinux.org>

# https://github.com/amnezia-vpn/amnezia-client/archive/%version/amnezia-client-%version.tar.gz
Source0: amnezia-client-%version.tar
# https://github.com/frankosterfeld/qtkeychain/archive/%sort_filter_proxy_model_commit/qtkeychain-%sort_filter_proxy_model_commit.tar.gz
Source1: SortFilterProxyModel-%sort_filter_proxy_model_commit.tar
# https://github.com/frankosterfeld/qtkeychain/archive/%qtkeychain_commit/qtkeychain-%qtkeychain_commit.tar.gz
Source2: qtkeychain-%qtkeychain_commit.tar
# https://github.com/amnezia-vpn/QSimpleCrypto/archive/%qsimplecrypto_commit/QSimpleCrypto-%qsimplecrypto_commit.tar.gz
Source3: QSimpleCrypto-%qsimplecrypto_commit.tar

Patch0: %name-use-system-libs-instead-3rd-prebuilt.patch
Patch1: %name-openvpn-exec-path.patch
Patch2: %name-update-resolv-conf-path.patch
Patch3: %name-wireguard-exec-path.patch
Patch4: %name-tun2socks-exec-path.patch
Patch5: %name-tun2-sudo.patch
Patch6: %name-locale.patch

BuildRequires: libsecret-devel
BuildRequires: libssh-devel
BuildRequires: libssl-devel
BuildRequires: libstdc++-devel-static
BuildRequires: qt6-5compat-devel
BuildRequires: qt6-remoteobjects-devel
BuildRequires: qt6-svg-devel
BuildRequires: qt6-tools-devel

%description
Amnezia is an open-source VPN client, with a key feature that enables you to deploy your own VPN server on your server.

%package client
Summary: The best client for self-hosted VPN
Group: System/Servers
Requires: %name-service = %EVR
Requires: amneziawg-go
Requires: cloak-client
Requires: openvpn
Requires: qt6-5compat
Requires: qt6-declarative
Requires: qt6-svg
Requires: shadowsocks-libev
Requires: tun2socks
Requires: xray-core

%description client
Amnezia is an open-source VPN client, with a key feature that enables you to deploy your own VPN server on your server.

%package service
Summary: The best client for self-hosted VPN (systemd service)
Group: System/Servers

%description service
Amnezia is an open-source VPN client, with a key feature that enables you to deploy your own VPN server on your server.

This package contains systemd service files.

%prep
%setup -n amnezia-client-%version -b 1 -b 2 -b 3
%autopatch -p1

%__mv -Tf ../SortFilterProxyModel-%sort_filter_proxy_model_commit client/3rd/SortFilterProxyModel
%__mv -Tf ../qtkeychain-%qtkeychain_commit client/3rd/qtkeychain
%__mv -Tf ../QSimpleCrypto-%qsimplecrypto_commit client/3rd/QSimpleCrypto

%build
%add_optflags -Wno-error=return-type
%cmake
%cmake_build

%install
%__mkdir_p %buildroot{%_bindir,%_desktopdir,%_iconsdir/hicolor/512x512/apps,%_libexecdir/%name,%_unitdir}

%__install -Dp -m0755 %_cmake__builddir/client/AmneziaVPN %buildroot%_bindir/
%__install -Dp -m0644 deploy/data/linux/AmneziaVPN.png %buildroot%_iconsdir/hicolor/512x512/apps/

sed \
    -e 's|/usr/share/pixmaps/||' \
    -e 's|.png||' \
    deploy/installer/config/AmneziaVPN.desktop.in > %buildroot%_desktopdir/AmneziaVPN.desktop

sed -i '/Version=/d' %buildroot%_desktopdir/AmneziaVPN.desktop

sed \
    -e 's|/opt/AmneziaVPN/service/||' \
    -e 's|.sh||' \
    deploy/data/linux/AmneziaVPN.service > %buildroot%_unitdir/AmneziaVPN.service

sed -i '/Environment=/d' %buildroot%_unitdir/AmneziaVPN.service

%__install -Dp -m0755 %_cmake__builddir/service/server/AmneziaVPN-service %buildroot%_bindir/
%__install -Dp -m0755 deploy/data/linux/client/bin/update-resolv-conf.sh %buildroot%_libexecdir/%name/

%post service
%post_systemd_postponed AmneziaVPN.service

%preun service
%systemd_preun AmneziaVPN.service

%files client
%doc README.md README_RU.md
%_bindir/AmneziaVPN
%_desktopdir/AmneziaVPN.desktop
%_iconsdir/hicolor/512x512/apps/AmneziaVPN.png
%_libexecdir/%name

%files service
%_bindir/AmneziaVPN-service
%_unitdir/AmneziaVPN.service

%changelog
