Name: amneziawg-tools
Version: 1.0.20250706
Release: alt1
Summary: Fast, modern, secure VPN tunnel
License: GPLv2
Group: System/Servers
URL: https://github.com/amnezia-vpn/amneziawg-tools
VCS: https://github.com/amnezia-vpn/amneziawg-tools
Source0: %name-%version.tar
BuildRequires: systemd

%description
%description
AmneziaWG is a user-friendly VPN solution based on the WireGuard protocol, enhanced with
additional features for seamless integration into the AmneziaVPN ecosystem. It leverages
the same state-of-the-art cryptography as WireGuard (the "Noise" protocol), offering
modern security, high performance, and simplicity compared to traditional VPN solutions
like IPSec and OpenVPN. Designed for versatility, it works equally well on embedded systems,
servers, and desktop environments, prioritizing both speed and ease of configuration.
Like WireGuard, it operates over UDP for efficient data transmission.

This package provides customized management tools (awg) and utilities for configuring
and interacting with AmneziaWG

%prep
%setup

%build
%make_build RUNSTATEDIR=/run -C src

%install
%makeinstall \
	     DESTDIR=%buildroot \
             BINDIR=%_bindir \
	     MANDIR=%_mandir \
	     RUNSTATEDIR=/run \
             WITH_BASHCOMPLETION=yes \
	     WITH_WGQUICK=yes \
	     WITH_SYSTEMDUNITS=yes \
	     -C src

%files
%doc README.md contrib
%_bindir/awg
%_bindir/awg-quick
%dir %_sysconfdir/amnezia
%_sysconfdir/amnezia/amneziawg/
%_datadir/bash-completion/completions/awg
%_datadir/bash-completion/completions/awg-quick
%_unitdir/awg-quick@.service
%_unitdir/awg-quick.target
%_mandir/man8/awg.8*
%_mandir/man8/awg-quick.8*

%changelog
