%define aprver 1
%define aprdir %_builddir/%name-%version
%add_findreq_skiplist %_datadir/apr-1/build/config.guess

Name: apr%aprver
Version: 1.7.0
Release: alt4

Summary: Apache Portable Runtime
Group: System/Libraries
License: %asl
Url: http://apr.apache.org/

#Source: http://archive.apache.org/dist/apr/apr-%version.tar.gz
Source: apr-%version.tar

Patch: apr-1.7.0-upstream-fix-build-autoconf-2.70.patch

BuildRequires(pre): rpm-macros-branch
BuildPreReq: rpm-build-licenses

%def_disable static
%{?_enable_static:BuildPreReq: glibc-devel-static}

# Automatically added by buildreq on Wed Sep 03 2008
BuildRequires: gcc-c++ glibc-devel-static libuuid-devel python-modules

%package -n lib%name
Summary: Apache Portable Runtime shared library
Group: System/Libraries

%package -n lib%name-devel
Summary: Apache Portable Runtime development files
Group: Development/C
Requires: lib%name = %version-%release
Conflicts: libapr-devel

%if_enabled static
%package -n lib%name-devel-static
Summary: Apache Portable Runtime static library
Group: Development/C
Requires: lib%name-devel = %version-%release
%endif

%description
The mission of the Apache Portable Runtime (APR) is to provide a free
library of C data structures and routines, forming a system portability
layer to as many operating systems as possible, including Unices,
MS Win32, BeOS and OS/2.

%description -n lib%name
The mission of the Apache Portable Runtime (APR) is to provide a free
library of C data structures and routines, forming a system portability
layer to as many operating systems as possible, including Unices,
MS Win32, BeOS and OS/2.
This package contains APR shared library.

%description -n lib%name-devel
The mission of the Apache Portable Runtime (APR) is to provide a free
library of C data structures and routines, forming a system portability
layer to as many operating systems as possible, including Unices,
MS Win32, BeOS and OS/2.
This package contains APR development files.

%if_enabled static
%description -n lib%name-devel-static
The mission of the Apache Portable Runtime (APR) is to provide a free
library of C data structures and routines, forming a system portability
layer to as many operating systems as possible, including Unices,
MS Win32, BeOS and OS/2.
This package contains APR static library.
%endif

%prep
%setup -n apr-%version
%patch -p1

%build
LIBTOOL_M4=%_datadir/libtool/aclocal/libtool.m4 ./buildconf
%configure \
	--prefix=%prefix \
	--includedir=%_includedir/apr-%aprver \
	--with-installbuilddir=%_datadir/apr-%aprver/build \
	--enable-threads \
	--disable-epoll_create1 \
	--disable-dup3 \
	--disable-accept4 \
	--disable-sock_cloexec \
	--with-devrandom \
%ifarch %mips32
        --disable-nonportable-atomics \
%endif
	%{subst_enable static}
%make_build

%install
%makeinstall_std
install -m755 build/PrintPath %buildroot%_datadir/apr-%aprver/build/
find %buildroot%_bindir -type f -print0 |
	xargs -r0 grep -FZl "%aprdir" -- |
	xargs -r0 sed -i "s,%aprdir,%_datadir/apr-%aprver," --
find %buildroot%_datadir -type f -print0 |
	xargs -r0 grep -FZl "%aprdir" -- |
	xargs -r0 sed -i "s,%aprdir\(/build\)\?,%_datadir/apr-%aprver/build," --

%check
make check

%files -n lib%name
%doc CHANGES LICENSE NOTICE
%_libdir/lib*.so.*

%files -n lib%name-devel
%doc docs/APRDesign.html docs/canonical_filenames.html
%doc docs/incomplete_types docs/non_apr_programs
%_bindir/*-config
%_libdir/lib*.so
%_libdir/*.exp
%_pkgconfigdir/apr-%aprver.pc
%_datadir/apr-%aprver
%_includedir/*

%if_enabled static
%files -n lib%name-devel-static
%_libdir/lib*.a
%endif

%changelog
