%def_disable coverage

Name: apt-repo-tools
Version: 0.8.1
Release: alt1

Summary: Utilities to create APT repositories
License: GPLv2+
Group: Development/Other

Source: %name-%version.tar

Requires: librpmio(PGPHASHALGO_BLAKE2B)%{?_is_libsuff:(%{_libsuff}bit)} = 100
Provides: apt-utils = 0.5.15lorg4
Obsoletes: apt-utils <= 0.5.15lorg4

BuildRequires: gcc-c++ libapt-devel librpm-devel
%if_enabled coverage
BuildRequires: lcov
%endif

%description
This package contains the utility programs that can prepare a repository
of RPMS binary and source packages for future access by APT (by
generating the indices): genbasedir, genpkglist, gensrclist.

%prep
%setup

%build
# To avoid some errors on API change:
%add_optflags -Werror=overloaded-virtual
# A style enforcement: always use the keyword, which helps to avoid API misuse
%add_optflags -Werror=suggest-override
%add_optflags -Werror=return-type
./bootstrap
mkdir build
cd build
%define _configure_script ../configure
%configure \
	%{?_enable_coverage:--enable-code-coverage} \
	%nil
%make_build

%install
%makeinstall_std -C build
mkdir -p %buildroot/var/cache/apt/gen{pkg,src}list

%check
%make_build check -C build VERBOSE=1
%if_enabled coverage
make code-coverage-capture -C build
%endif

%files
/usr/bin/genpkglist
/usr/bin/gensrclist
/usr/bin/genbasedir
/usr/bin/pkglist-query
%defattr(2770,root,rpm,2770)
%dir /var/cache/apt/genpkglist
%dir /var/cache/apt/gensrclist

%changelog
