# vim: set ft=spec:

Name: aptitude
Version: 0.4.5
Release: alt16

Summary: Terminal-based apt frontend
Group: System/Configuration/Packaging
License: GPL
Url: http://people.debian.org/~dburrows/aptitude

# git://git.altlinux.org/gears/a/aptitude.git
Source: %name-%version.tar
Patch: %name-%version-%release.patch

BuildRequires: libapt-devel >= 0.5.15lorg2-alt42

# Automatically added by buildreq on Sat Oct 07 2006
BuildRequires: cppunit-devel docbook-dtds docbook-style-xsl gcc-c++ html2text libapt-devel libncursesw-devel libsigc++2.0-devel xsltproc

%description
aptitude is a terminal-based apt frontend.  This is a heavily
emasculated version of Debian software, besause some features
can't be ported to apt-rpm.

%package doc
Summary: English manual for aptitude, a terminal-based apt frontend
Group: Books/Computer books
# Can't use noarch:
#--- aptitude-doc-0.4.5-alt5.noarch.rpm.i586     2009-12-21 18:23:35 +0300
#+++ aptitude-doc-0.4.5-alt5.noarch.rpm.x86_64   2009-12-21 18:23:35 +0300
#@@ -77,35 +77,35 @@
# /usr/share/doc/aptitude-doc-0.4.5/index.html
#-/usr/share/doc/aptitude-doc-0.4.5/ld-id2608397.html
#+/usr/share/doc/aptitude-doc-0.4.5/ld-id3016206.html
#...
#BuildArch: noarch
Conflicts: %name < %version-%release
Conflicts: %name > %version-%release

%description doc
aptitude is a terminal-based apt frontend.  This package contains
the English version of the aptitude user's manual in HTML format.

%prep
%setup
%patch -p1
find -type f -name '*.cc' -print0 |
	xargs -r0 sed -i '1,1 s/^/#include "config.h"\n/' --

%build
# Needed for APT API (e.g., std::optional):
%ifnarch %e2k
%add_optflags -std=gnu++17
%else
%add_optflags -std=gnu++14
%endif
# To avoid some errors on API change:
%add_optflags -Werror=overloaded-virtual
# A style enforcement: always use the keyword, which helps to avoid API misuse
%add_optflags -Werror=suggest-override
%add_optflags -Werror=return-type
%add_optflags -fno-strict-aliasing
# gettext uses mkinstalldirs...
touch mkinstalldirs
# STFU, automake!
touch ChangeLog
%autoreconf

%configure \
  --disable-werror \
  --disable-docs
%make_build
%make_build -C doc/en

%install
mkdir -p %buildroot%_localstatedir/%name
%makeinstall_std
rm -rf %buildroot%_mandir

%make_install DESTDIR=%buildroot -C doc/en install-man
install -p -m644 doc/en/README.en %buildroot%_datadir/%name/README
rm -f %buildroot%_datadir/%name/function_*

%find_lang %name

%files -f %name.lang
%doc AUTHORS FAQ NEWS
%_bindir/*
%_datadir/%name
%_man8dir/%name.8*
%_localstatedir/*

%files doc
%doc doc/en/output-html/*

%changelog
