Name: arm-none-eabi-gcc
Version: 15.2.0
Release: alt1

Summary: GNU Compiler Collection
License: GPLv3+
Group: Development/C
Url: https://gcc.gnu.org/

Requires: arm-none-eabi-newlib

Source: %name-%version-%release.tar

BuildRequires: gcc-c++ flex zlib-devel libgmp-devel libmpc-devel autogen
BuildRequires: arm-none-eabi-binutils >= 2.41
BuildRequires: arm-none-eabi-newlib

Requires: arm-none-eabi-binutils >= 2.41
%add_python_req_skip libstdcxx gdb

%package c++
Summary: Cross Compiling GNU GCC targeted at arm-none-eabi
Group: Development/Tools
AutoReq: yes, nopython
Requires: %name = %version-%release

%description
This package contains the GNU Compiler Collection version 14.2.0.
You'll need this package in order to compile C code.
It is also required for all other GCC compilers.

%description c++
This package adds C++ support to the GNU Compiler Collection.
It includes support for most of the current C++ specification,
including templates and exception handling.

%define target         arm-none-eabi
%define _libexecdir /usr/libexec
%brp_strip_none %_libexecdir/%target/*
%brp_strip_none %_libexecdir/gcc/%target/*.[oa]
%add_verify_elf_skiplist %_libexecdir/%target/*
%add_verify_elf_skiplist %_libexecdir/gcc/%target/*

%prep
%setup
contrib/gcc_update --touch


%build
mkdir obj-%target; cd obj-%target

../configure \
            --prefix=%_libexecdir \
            --bindir=%_bindir \
            --libexecdir=%_libexecdir \
            --libdir=%_libexecdir \
            --mandir=%_mandir \
            --infodir=%_infodir \
            --target=%target \
            --with-python-dir=%target/share/gcc-%version/python \
            --with-pkgversion="%version-%release" \
            --with-bugurl="https://bugzilla.altlinux.org/" \
            \
            --disable-decimal-float \
            --disable-libffi \
            --disable-libgomp \
            --disable-libmudflap \
            --disable-libquadmath \
            --disable-libssp \
            --disable-libstdcxx-pch \
            --disable-nls \
            --disable-shared \
            --disable-threads \
            --disable-tls \
            \
            --enable-checking=release \
            --enable-languages=c,c++ \
            --enable-plugins \
            --with-newlib \
            --with-gnu-as \
            --with-gnu-ld \
            --enable-multilib \
            --with-multilib-list=aprofile,rmprofile \
            --with-gmp \
            --with-mpfr \
            --with-mpc \
            --with-headers=yes \
            --with-system-zlib \
            --with-sysroot=%_libexecdir/%target

%make_build \
CFLAGS_FOR_TARGET='-Os -ffunction-sections -fdata-sections' \
CXXFLAGS_FOR_TARGET='-Os -fno-exceptions'
mv %target %target-nano
%make_build \
CFLAGS_FOR_TARGET='-Os -ffunction-sections -fdata-sections' \
CXXFLAGS_FOR_TARGET='-Os'

%install
%makeinstall_std -C obj-%target
find obj-%target/%target-nano -type f -name libstdc++.a | while read f; do
	o=$(echo $f |sed -r 's,^[^/]+/[^/]+(.+)libstdc\+\+-v3/src/\.libs/,\1,; s,\.a$,_nano.a,')
	install -pm0644 -D $f %buildroot%_libexecdir/%target/lib/$o
	%_libexecdir/%target/bin/ranlib %buildroot%_libexecdir/%target/lib/$o
done
find obj-%target/%target-nano -type f -name libsupc++.a | while read f; do
	o=$(echo $f |sed -r 's,^[^/]+/[^/]+(.+)libstdc\+\+-v3/libsupc\+\+/\.libs/,\1,; s,\.a$,_nano.a,')
	install -pm0644 -D $f %buildroot%_libexecdir/%target/lib/$o
	%_libexecdir/%target/bin/ranlib %buildroot%_libexecdir/%target/lib/$o
done
# we don't want these as we are a cross version
rm -r %buildroot%_infodir
rm -r %buildroot%_man7dir
rm -f %buildroot%_libdir/libcc1* ||:
rm -f %buildroot%_libexecdir/libcc1* ||:
# these directories are often empty
rmdir %buildroot%_libexecdir/%target/share/gcc-* ||:
rmdir %buildroot%_libexecdir/%target/share ||:
# and these aren't usefull for embedded targets
rm -r %buildroot%prefix/lib*/gcc/%target/*/install-tools ||:
rm -r %buildroot%_libexecdir/gcc/%target/*/install-tools ||:
find  %buildroot%_libexecdir/ -type f -name \*.la -delete

%files
%doc COPYING* README
%_bindir/%target-*
%exclude %_bindir/%target-?++
%_libexecdir/gcc/%target
%_man1dir/%target-*.1*
%exclude %_man1dir/%target-?++.1*
%exclude %_libexecdir/gcc/%target/*/cc1plus

%files c++
%_bindir/%target-?++
%_libexecdir/%target
%_man1dir/%target-g++.1*
%_libexecdir/gcc/%target/*/cc1plus

%changelog
