Name: asc
Version: 2.8.0.2
Release: alt2

Summary: ASC - a battle isle clone
License: GPLv2+
Group: Games/Strategy

Url: http://www.asc-hq.org/
# repacked 'https://heanet.dl.sourceforge.net/project/asc-hq/ASC Source/2.6.0/asc-%%version.tar.bz2'
Source: asc-%version.tar
Source1: frontiers.ogg
Source2: machine_wars.ogg
Source3: time_to_strike.ogg
Source10: %name.desktop
Source11: %name.png
Patch1: asc-upstream-gcc10-compat.patch
Patch2: asc-2.8.0.2-gcc-11.patch
Packager: Vitaly Lipatov <lav@altlinux.ru>

BuildRequires: boost-program_options-devel bzlib-devel gcc-c++
BuildRequires: libSDL_image-devel libSDL_mixer-devel libSDL_sound-devel
BuildRequires: libexpat-devel libfreetype-devel liblua5-devel libphysfs-devel libsigc++2-devel
BuildRequires: libwxGTK3.2-devel
BuildRequires: libcurl-devel libogg-devel libpng-devel libxvid-devel zip libjpeg-devel
BuildRequires: desktop-file-utils

%description
ASC aims at providing a free clone of Bluebyte's Battle Isle(tm) series.

%prep
#bug in upstream tarbal, contains 2.8.0.1 dir instead of 2.8.0.2
#setup -n asc-2.8.0.1

%setup
%patch1 -p1
%patch2 -p1
cp -a %SOURCE1 %SOURCE2 %SOURCE3 data/music/
# see https://slackbuilds.org/slackbuilds/14.2/games/d2x-rebirth/libphysfs-3.0.1.patch
sed -i "s|__EXPORT__|PHYSFS_DECL|" source/libs/paragui/src/core/physfsrwops.h

%build
%autoreconf

%add_optflags -fpermissive
%ifarch %e2k
# -std=c++03 by default as of lcc 1.23.12
%add_optflags -std=c++11
%endif
export CXXFLAGS="$RPM_OPT_FLAGS -std=c++11 -D__EXPORT__="
%configure --enable-genparse --disable-paraguitest

#configure
%make_build

%install
%makeinstall

mkdir -p %buildroot%_desktopdir
desktop-file-install --dir %buildroot%_desktopdir %SOURCE10
mkdir -p %buildroot%_iconsdir/hicolor/32x32/apps
mkdir -p %buildroot%_iconsdir/hicolor/256x256/apps
install -p -m 644 data/icons/program-icon.png \
    %buildroot%_iconsdir/hicolor/32x32/apps/%name.png
install -p -m 644 %SOURCE11 \
    %buildroot%_iconsdir/hicolor/256x256/apps

%files
%_gamesdatadir/asc/
%_bindir/asc*
%_man6dir/*
%{_datadir}/applications/*%{name}.desktop
%{_datadir}/icons/hicolor/*/apps/%{name}.png
%_datadir/appdata/asc.appdata.xml
%doc AUTHORS COPYING ChangeLog README TODO doc

%changelog
