%define _unpackaged_files_terminate_build 1
%define docdir %_docdir/%name-%version

Name: asciidoc
Version: 10.2.1
Release: alt1

Summary: asciidoc converts an AsciiDoc text file to DocBook, HTML or LinuxDoc

Group: Text tools
License: GPL-2.0-or-later
Url: http://asciidoc.org

BuildArch: noarch

# Source-url: https://github.com/asciidoc-py/asciidoc-py/releases/download/%version/asciidoc-%version.tar.gz
Source: %name-%version.tar

BuildRequires(pre): rpm-build-tex
BuildRequires: python3-devel python3-module-pip python3-module-setuptools python3-module-wheel
BuildRequires: xsltproc docbook-style-xsl
#BuildRequires: source-highlight
#BuildRequires: graphviz

%description
The asciidoc(1) command translates the AsciiDoc text file to the backend
formatted file.

AsciiDoc is a text document format for writing short documents, articles,
books and UNIX man pages.

%package a2x
Summary: a2x converts AsciiDoc text file to PDF, XHTML, HTML Help, manpage or plain text
Group: Text tools
Requires: %name = %version-%release
Requires: xsltproc docbook-style-xsl
Requires: w3m
# Requires: lynx
# Requires: source-highlight

%description a2x
A DocBook toolchain wrapper script that translates an AsciiDoc text
file to PDF, XHTML (single page or chunked), man page, HTML Help
or plain text formats. PDF, XHTML, man page and HTML Help formats are
generated using the asciidoc(1)/xsltproc(1)/DocBook XSL Stylesheets
toolchain. Plain text is produced by passing asciidoc(1) generated HTML
through lynx(1). The htmlhelp format option generates .hhp, .hhc and
.html files suitable for compilation to an HTML Help .chm file.

Install asciidoc-latex if you need generate PDF files.

%package latex
Summary: Support for asciidoc LaTeX output
Group: Text tools
Requires: %name = %EVR
Requires: dblatex

%description latex
Support for asciidoc LaTeX output.

%package doc
Summary: AsciiDoc documentation and examples
Group: Development/Documentation

%description doc
The asciidoc(1) command translates the AsciiDoc text file to the backend
formatted file.

AsciiDoc is a text document format for writing short documents, articles,
books and UNIX man pages.

This package contains AsciiDoc documentation and examples.

%prep
%setup

%build
%autoreconf
%configure docdir=%docdir

%install
%make_install DESTDIR=%buildroot install docs manpages
mkdir -p %buildroot%_man1dir
mv %buildroot%docdir/doc/{asciidoc.1,a2x.1,testasciidoc.1} %buildroot%_man1dir/
install -pD %buildroot%python3_sitelibdir/%name/resources/dblatex/asciidoc-dblatex.sty \
  %buildroot%_texmfmain/tex/latex/%name/asciidoc-dblatex.sty

# install extra docs for asciidoc package
install -d %buildroot%docdir/
install -pD -m644 COPYRIGHT  %buildroot%docdir/

%files
%_bindir/%name
%python3_sitelibdir/*
%exclude %python3_sitelibdir/asciidoc/resources/filters/latex
%exclude %python3_sitelibdir/asciidoc/resources/filters/music

%_man1dir/%name.*
%_man1dir/test%name.*
%dir %docdir
%doc %docdir/BUGS.adoc
%doc %docdir/CHANGELOG.adoc
%doc %docdir/COPYRIGHT
%doc %docdir/README.md

%files a2x
%_bindir/a2x
%_man1dir/a2x.*

%files latex
%python3_sitelibdir/%name/resources/filters/latex
%_texmfmain/tex/latex/%name/

%files doc
%doc %docdir
%exclude %docdir/BUGS.adoc
%exclude %docdir/CHANGELOG.adoc
%exclude %docdir/COPYRIGHT
%exclude %docdir/README.md

%changelog
