Summary: A smaller version of the Bourne shell
Name: ash
Version: 0.5.11.18.g6f6d1f2
Release: alt3

License: BSD-3-Clause
Group: Shells
Url: http://gondor.apana.org.au/~herbert/dash/

Packager: Alexey Gladkov <legion@altlinux.ru>

Source: %name-%version.tar
Patch01: 0001-Implement-losetup-as-builtin.patch
Patch02: 0002-Use-CFLAGS-to-compile-helpers.patch
Patch03: 0003-Enable-large-file-support-when-available.patch

Conflicts: mkinitrd <= 1:1.7
Provides: dash

# Automatically added by buildreq on Mon Jun 19 2006
BuildRequires: glibc-devel-static

%description
The %name shell is a clone of Berkeley's Bourne shell.  Ash
supports all of the standard sh shell commands, but is considerably
smaller than bash.  The %name shell lacks some features (for example,
command-line histories), but needs a lot less memory.

You should install %name if you need a lightweight shell with many of the
same capabilities as the bash shell.

%package static
Summary: A smaller version of the Bourne shell statically linked
License: BSD-3-Clause
Group: Shells

%description static
The %name shell is a clone of Berkeley's Bourne shell.  Ash
supports all of the standard sh shell commands, but is considerably
smaller than bash.  The %name shell lacks some features (for example,
command-line histories), but needs a lot less memory.

You should install %name if you need a lightweight shell with many of the
same capabilities as the bash shell.

This version is statically compiled.

%prep
%setup -q
%autopatch -p1

sed -i -e 's,\$(tempfile),`mktemp -t ash.XXXXXX`,' src/mkbuiltins

%build
BUILD_FLAGS="%optflags_warnings -Wunused-function -Wunused-label -Wunused-variable -Wunused-value"

Werror="-Werror"
# On e2k, lcc ignores the GCC pragma, which leads to compilation errors. We
# won't wait for lcc to fix it and just turn off -Werror.
%ifarch %e2k
Werror=
%endif

%autoreconf
%define _configure_script ../configure
rm -rf build-dynamic build-static
mkdir -p build-dynamic build-static

cd build-dynamic
	export CFLAGS="$BUILD_FLAGS $Werror"
	%configure --disable-dependency-tracking
	%make_build
	mv src/dash sh.dynamic
cd -

cd build-static
	export CFLAGS="$BUILD_FLAGS $Werror"
	%configure --disable-dependency-tracking --enable-static
	%make_build
	mv src/dash sh.static
cd -

%install
mkdir -p %buildroot/lib/mkinitrd/initramfs/bin

install -m755 -pD build-dynamic/sh.dynamic %buildroot/bin/%name
install -m755 -pD build-static/sh.static %buildroot/bin/%name.static
ln -s %name %buildroot/bin/dash

install -m644 -pD src/dash.1 %buildroot/%_man1dir/%name.1
ln -s %name.1 %buildroot/%_man1dir/dash.1

%files
/bin/%name
/bin/dash
%_man1dir/*

%files static
/bin/%name.static

%changelog
