#%define rel -beta4
%define rel %nil
Name: audacious
Version: 4.4.2
Release: alt1

Summary: Media player which uses a skinned interface

License: LicenseRef-Callaway-BSD
Group: Sound
Url: http://audacious-media-player.org/

Packager: Vitaly Lipatov <lav@altlinux.ru>

Source: http://distfiles.audacious-media-player.org/%name-%version%rel.tar

Patch: audacious-0.1.2-default-alsa.patch
Patch1: %name-as-needed.patch
#Patch2: %name-%version-lib.patch
Patch3: %name-2.5.0-alt-DSO.patch

# Typical environment for GNOME program
Requires(post,postun): desktop-file-utils
BuildPreReq: desktop-file-utils

BuildRequires: gcc-c++

BuildRequires: glib2-devel libgio-devel

BuildRequires: qt6-base-devel qt6-svg-devel

BuildRequires: libgtk+3-devel

BuildRequires: libguess-devel >= 1.2

BuildRequires: libarchive-devel

Requires: %name-plugins

%description
Audacious is a media player forked from BMP (Beep Media Player) which uses a
skinned interface based on Winamp 2.x skins, and in turn based on XMMS.

%package -n lib%name
Summary: Library files for the audacious media player
Group: Development/Other

%description -n lib%name
Audacious is a media player forked from BMP (Beep Media Player) which uses a
skinned interface based on Winamp 2.x skins, and in turn based on XMMS.

Library file required to run audacious.


%package -n lib%name-devel
Summary: Development files for the audacious media player
Group: Development/Other
Requires: lib%name = %version
Provides: %name-devel
Obsoletes: %name-devel

%description -n lib%name-devel
Audacious is a media player forked from BMP (Beep Media Player) which uses a
skinned interface based on Winamp 2.x skins, and in turn based on XMMS.

Development files required to develop plugins for audacious.


%prep
%setup -n %name-%version%rel

%build
%configure \
    --with-buildstamp="ALT Linux package"  \
    --disable-rpath \
    --enable-libarchive \
    --disable-dependency-tracking \
%ifnarch x86_64
    --disable-sse2 \
%endif
    --enable-chardet

%make_build

%install
%makeinstall_std
%find_lang %name

%files -f %name.lang
%doc AUTHORS
%_bindir/%name
%_bindir/audtool
%_desktopdir/*.desktop
%_datadir/%name/
%_iconsdir/hicolor/48x48/apps/audacious.png
%_iconsdir/hicolor/scalable/apps/audacious.svg
%_man1dir/*

%files -n lib%name
#_libdir/libaudclient.so.*
#%_libdir/libaudid3tag.so.*
%_libdir/libaudtag.so.*
#%_libdir/libSAD.so.*
%_libdir/libaudcore.so.*
%_libdir/libaudqt.so.*
%_libdir/libaudgui.so.*

%files -n lib%name-devel
%_includedir/%name/
#%_includedir/libSAD/
%_includedir/libaudcore/
%_includedir/libaudqt/
%_includedir/libaudgui/
%_pkgconfigdir/*.pc
%_libdir/*.so

%changelog
