#%define rel -beta4
%define rel %nil
%define oname audacious

%def_enable pulse
%def_disable jack

Name: audacious-plugins
Version: 4.4.2
Release: alt1

Summary: Plugins for Audacious
License: LicenseRef-Callaway-BSD
Group: Sound

Url: http://audacious-media-player.org/
Source: http://distfiles.audacious-media-player.org/%name-%version%rel.tar
Packager: Vitaly Lipatov <lav@altlinux.ru>

Requires: %oname = %version

BuildRequires: gcc-c++ libSDL2-devel libXcomposite-devel libavformat-devel libbinio-devel libbs2b-devel libcddb-devel libcdio-paranoia-devel libcue-devel libcurl-devel libdbus-glib-devel libfaad-devel libflac-devel libfluidsynth-devel libgtk+3-devel liblame-devel liblirc-devel libmms-devel libmodplug-devel libmpg123-devel libneon-devel libnotify-devel libpulseaudio-devel libsamplerate-devel libvorbis-devel libwavpack-devel libxml2-devel libalsa-devel

BuildRequires: lib%oname-devel = %version

BuildRequires: qt6-base-devel qt6-multimedia-devel qt6-svg-devel

BuildRequires: libglade-devel libprojectM-devel >= 1.1 libsidplayfp-devel libsoxr-devel libadplug-devel pipewire-libs-devel

BuildRequires: libopus-devel libopusfile-devel libjson-glib-devel libopenmpt-devel

# global hotkeys (X11) disabled due to missing dependency: Qt6Gui >= 6.2 x11 xcb-proto
BuildRequires: libX11-devel libxcb-devel

%description
Base plugins for Audacious.
It includes some great other features like various output plugins,
last.fm plugins, LIRC support.
This package contains the base I/O plugins:
  * Audio CD reading
  * MPEG support (mp3)
  * Ogg Vorbis support
  * WMA support
  * AAC support
  * FLAC support
  * ALAC support
  * WAVE support
  * OPUS support
  * ALSA output
  * OSS output
  * Disk writer output

%prep
%setup -n %name-%version%rel
%ifarch %e2k
# strip UTF-8 BOM for lcc < 1.24
find -type f -name '*.cpp' -o -name '*.hpp' -o -name '*.cc' -o -name '*.h' |
	xargs -r sed -ri 's,^\xEF\xBB\xBF,,'
%endif

%build
%configure \
	--enable-amidiplug \
	--enable-sid \
	%{subst_enable pulse} \
	%{subst_enable jack} \
%ifarch armh
	--disable-qtglspectrum \
%endif
%ifnarch x86_64
	--disable-sse2 \
%endif
	#
%make_build

%install
%makeinstall_std
%find_lang %name

%files -f %name.lang
%_datadir/%oname/
%dir %_libdir/%oname/
%_libdir/%oname/*

%changelog
