%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict

%global optflags_lto %optflags_lto -ffat-lto-objects

%def_enable static
%def_enable docs
%def_enable flac
%def_enable check
%ifarch %valgrind_arches
%def_disable valgrind
%endif

%define sover 1

Name: audiofile
Version: 0.3.6
Release: alt5

Summary: Library to handle various audio file formats
License: LGPL-2.1-or-later
Group: System/Libraries
Url: http://www.68k.org/~michael/%name

Vcs: https://github.com/mpruett/audiofile.git
Source: %url/%name-%version.tar

Patch: %name-%version-alt4.patch
Patch1: %name-0.3.6-alt-configure.patch

# debian patches
Patch4: 04_clamp-index-values-to-fix-index-overflow-in-IMA.cpp.patch
Patch5: 05_Always-check-the-number-of-coefficients.patch
Patch6: 06_Check-for-multiplication-overflow-in-MSADPCM-decodeSam.patch
Patch7: 07_Check-for-multiplication-overflow-in-sfconvert.patch
Patch8: 08_Fix-signature-of-multiplyCheckOverflow.-It-returns-a-b.patch
Patch9: 09_Actually-fail-when-error-occurs-in-parseFormat.patch
Patch10: 10_Check-for-division-by-zero-in-BlockCodec-runPull.patch
Patch11: 11_CVE-2018-13440.patch
Patch12: 12_CVE-2018-17095.patch

Requires: lib%name%sover = %EVR

BuildRequires(pre): rpm-macros-valgrind
BuildRequires: gcc-c++ glibc-devel-static libalsa-devel
%{?_enable_flac:BuildRequires: libflac-devel}
%{?_enable_docs:BuildRequires: asciidoc-a2x}
%{?_enable_check:
%{?_enable_valgrind:BuildRequires: valgrind}}

%package -n lib%name%sover
Summary: Shared library for %name
Group: System/Libraries

%package -n lib%name-devel
Summary: Includes and other files to develop %name applications
Group: Development/C
Requires: lib%name%sover = %EVR
Provides: %name-devel = %version
Obsoletes: %name-devel

%package -n lib%name-devel-static
Summary: Static libraries to develop %name applications
Group: Development/C
Requires: lib%name-devel = %EVR

%description
The Audio File Library handles reading and writing audio files in many
common formats.

Key goals of the Audio File Library are file format transparency and data
format transparency. The same calls for opening a file, accessing and
manipulating audio metadata (e.g. sample rate, sample format, textual
information, MIDI parameters), and reading and writing sample data will
work with any supported audio file format. Likewise, the format of the
audio data presented to the application need not be tied to the format
of the data contained in the file.

The following file formats are currently supported:
* AIFF/AIFF-C
* WAVE
* NeXT .snd/Sun .au
* Berkeley/IRCAM/CARL Sound File
* Audio Visual Research
* Amiga IFF/8SVX
* Creative Voice File
* NIST SPHERE
* Core Audio Format

The following compression formats are currently supported:
* G.711 mu-law and A-law
* IMA ADPCM
* Microsoft ADPCM

%description -n lib%name%sover
This package contains the library needed to run programs dynamically
linked with audiofile.

%description -n lib%name-devel
Include files and other resources you can use to develop
%name applications.

%description -n lib%name-devel-static
Static libraries you can use to develop
%name applications.

%prep
%setup
%patch -p1
%patch1 -b .m4
#debian
%patch4 -p1
%patch5 -p1
%patch6 -p1
%patch7 -p1
%patch8 -p1
%patch9 -p1
%patch10 -p1
%patch11 -p1
%patch12 -p1

%build
%autoreconf
%configure \
	--enable-largefile \
	%{subst_enable docs} \
	%{subst_enable static} \
	%{subst_enable flac} \
	%{?_enable_check:%{subst_enable valgrind}}
%nil
# SMP-incompatible build (man pages)
%make_build || %make

%install
%makeinstall_std

%check
%make -k check VERBOSE=1

%files
%_bindir/sfconvert
%_bindir/sfinfo
%{?_enable_docs:%_man1dir/*}
%doc README ACKNOWLEDGEMENTS TODO NEWS NOTES

%files -n lib%name%sover
%_libdir/*.so.*

%files -n lib%name-devel
%_libdir/*.so
%_pkgconfigdir/*
%_includedir/*
%{?_enable_docs:%_man3dir/*}

%if_enabled static
%files -n lib%name-devel-static
%_libdir/*.a
%endif

%changelog
