Group: Development/Java
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-java
# END SourceDeps(oneline)
BuildRequires: /proc rpm-build-java
BuildRequires: jpackage-default
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           auto
Summary:        Collection of source code generators for Java
Version:        1.6.1
Release:        alt1_3jpp11
License:        ASL 2.0

URL:            https://github.com/google/auto
# Source tarball is generated by script to ensure the correct tagged
# code is fetched for the various submodules
Source0:        auto-value-%{version}.tar.gz
Source1:        gen_auto_tarball.sh

BuildRequires:  maven-local
BuildRequires:  mvn(com.squareup:javapoet)
BuildRequires:  mvn(org.apache.maven.plugins:maven-invoker-plugin)

BuildArch:      noarch
Source44: import.info

%description
The Auto sub-projects are a collection of code generators
that automate those types of tasks.


%package common
Group: Development/Java
Summary:        Auto Common Utilities
# Obsoletes added in F30
Obsoletes:      %{name}-factory < %{version}-%{release}

%description common
Common utilities for creating annotation processors.


%package service
Group: Development/Java
Summary:        Provider-configuration files for ServiceLoader

%description service
A configuration/meta-data generator for
java.util.ServiceLoader-style service
providers.


%package value
Group: Development/Java
Summary:        Auto Value

%description value
Immutable value-type code generation for Java 1.6+.


%package value-annotations
Group: Development/Java
Summary:        Auto Value Annotations

%description value-annotations
Immutable value-type code generation for Java 1.6+.


%package value-parent
Group: Development/Java
Summary:        Auto Value Parent

%description value-parent
Immutable value-type code generation for Java 1.6+.


%package javadoc
Group: Development/Java
Summary:        Javadoc for %{name}
BuildArch: noarch

%description javadoc
This package contains javadoc for %{name}.


%prep
%setup -q -n auto-value-%{version}
find -name '*.class' -print -delete
find -name '*.jar' -print -delete

# remove unnecessary dependency on parent POM
%pom_remove_parent

# Disable factory module due to missing dep:
# com.google.googlejavaformat:google-java-format
%pom_disable_module factory build-pom.xml
# Missing dep on com.google.gwt:gwt
%pom_disable_module src/it/functional value/pom.xml
%pom_disable_module src/it/gwtserializer value/pom.xml

# Fix deps in service module
%pom_xpath_set "pom:parent/pom:version" 6 service
%pom_change_dep com.google.auto:auto-common com.google.auto:auto-common:0.10 service
%pom_remove_plugin org.apache.maven.plugins:maven-checkstyle-plugin
%pom_remove_plugin :maven-shade-plugin
%pom_remove_plugin :maven-shade-plugin value/processor

%mvn_package :build-only __noinstall


%build
# skip test suite because of unpackaged dependencies for tests
%mvn_build -sf -- -Dmaven.compiler.source=1.8 -Dmaven.compiler.target=1.8 -Dmaven.javadoc.source=1.8 -Dmaven.compiler.release=8 -f build-pom.xml


%install
%mvn_install


%files -f .mfiles-%{name}-parent
%dir %{_javadir}/%{name}
%doc README.md
%doc --no-dereference LICENSE.txt

%files common -f .mfiles-%{name}-common
%doc common/README.md
%doc --no-dereference LICENSE.txt

%files service -f .mfiles-%{name}-service
%doc service/README.md
%doc --no-dereference LICENSE.txt

%files value -f .mfiles-%{name}-value
%doc value/README.md
%doc --no-dereference LICENSE.txt

%files value-annotations -f .mfiles-%{name}-value-annotations
%doc --no-dereference LICENSE.txt

%files value-parent -f .mfiles-%{name}-value-parent
%doc --no-dereference LICENSE.txt

%files javadoc -f .mfiles-javadoc
%doc --no-dereference LICENSE.txt


%changelog
