%def_with mdns
%def_with python

%define avahi_user _avahi
%define autoipd_user _autoipd
%define avahi_group_priv netadmin

%define _runstatedir /run

Name: avahi
Version: 0.8
Release: alt4

Summary: Local network service discovery
License: LGPLv2
Group: System/Servers
Url: http://www.avahi.org/

Source: %name-%version-%release.tar

Requires: %name-autoipd = %version-%release
Requires: %name-daemon = %version-%release
Requires: %name-dnsconfd = %version-%release

%if_with mdns
Obsoletes: mdnsresponder
%endif

BuildRequires: gcc-c++
BuildRequires: desktop-file-utils
BuildRequires: glib2-devel
BuildRequires: intltool
BuildRequires: libcap-devel
BuildRequires: libdaemon-devel >= 0.13-alt2
BuildRequires: libdbus-devel
BuildRequires: libevent-devel
BuildRequires: libexpat-devel
BuildRequires: libgdbm-devel
BuildRequires: libgtk+3-devel
BuildRequires: libsystemd-devel
BuildRequires: qt5-base-devel
BuildRequires: xmltoman
%if_with python
BuildRequires: python3-devel python3(dbus) pkgconfig(pygobject-3.0)
%endif

%description
Avahi is a system which facilitates service discovery on
a local network -- this means that you can plug your laptop or
computer into a network and instantly be able to view other people
who you can chat with, find printers to print to or find files being
shared. This kind of technology is already found in MacOS X
(branded 'Rendezvous', 'Bonjour' and sometimes 'ZeroConf')
and is very convenient.

%package autoipd
Summary: Assigning link-local IP addresses service
Group: System/Servers
Conflicts: lib%name > %version-%release
Conflicts: lib%name < %version-%release

%package daemon
Summary: Local network service discovery
Group: System/Servers
Requires: chrooted-resolv dbus lib%name = %version-%release

%package dnsconfd
Summary: DNS configuration aquiring service
Group: System/Servers
Requires: lib%name = %version-%release %name-daemon = %version-%release

%package -n lib%name
Summary: Libraries for avahi
Group: System/Libraries

%if_with mdns
Obsoletes: libmdnsresponder
Provides: libmdnsresponder
%endif

%package -n lib%name-glib
Summary: Glib libraries for avahi
Group: System/Libraries
Requires: lib%name = %version-%release

%package -n lib%name-gobject
Summary: GObject'ified version of avahi API
Group: System/Libraries
Requires: lib%name = %version-%release
Requires: lib%name-glib = %version-%release

%package -n lib%name-libevent
Summary: Libevent mainloop adapter for avahi
Group: System/Libraries
Requires: lib%name = %version-%release

%package -n lib%name-qt5
Summary: Gt5 UI libraries for avahi
Group: System/Libraries
Requires: lib%name = %version-%release

%package -n lib%name-ui
Summary: GTK3 UI libraries for avahi
Group: System/Libraries
Requires: lib%name = %version-%release
Requires: lib%name-glib = %version-%release
Provides: lib%name-ui-gtk3 = %version-%release
Obsoletes: lib%name-ui-gtk3

%package -n python3-module-%name
Summary: Python bindings for Avahi
Group: Development/Python

%package bookmarks
Summary: Web service showing mDNS/DNS-SD announced HTTP services using the Avahi
Group: Networking/WWW
Requires: python3(twisted.internet.gireactor)
BuildArch: noarch

%package tools
Summary: Tools for mDNS browsing and publishing
Group: System/Base
Requires: lib%name = %version-%release

%package ui
Summary: UI tools for mDNS discovery
Group: Graphical desktop/Other
Requires: %name-daemon = %version-%release

%package -n lib%name-devel
Summary: Libraries and header files for avahi development
Group: Development/C
Provides: lib%name-glib-devel = %version-%release
Provides: lib%name-gobject-devel = %version-%release
Provides: lib%name-ui-devel = %version-%release
Provides: lib%name-ui-gtk3-devel = %version-%release
Obsoletes: lib%name-glib-devel lib%name-gobject-devel
Obsoletes: lib%name-ui-devel lib%name-ui-gtk3-devel
%if_with mdns
Obsoletes: libmdnsresponder-devel
%endif

# {{{ descriptions

%description autoipd
avahi-autoipd is an implementation of IPv4LL as defined in RFC3927,
a technology for assigning link-local IP addresses without DHCP server.
The same functionality has been available on Windows under the name APIPA.
While it is not the first implemenatation of this technology
for Free operating systems it is clearly the most powerful and hopefully
even the most secure. (Because it chroot()s and drops priviliges and suchlike)

%description daemon
Avahi is a system which facilitates service discovery on
a local network -- this means that you can plug your laptop or
computer into a network and instantly be able to view other people
who you can chat with, find printers to print to or find files being
shared. This kind of technology is already found in MacOS X
(branded 'Rendezvous', 'Bonjour' and sometimes 'ZeroConf')
and is very convenient.

This package provides avahi daemon.

%description dnsconfd
Avahi is a system which facilitates service discovery on
a local network -- this means that you can plug your laptop or
computer into a network and instantly be able to view other people
who you can chat with, find printers to print to or find files being
shared. This kind of technology is already found in MacOS X
(branded 'Rendezvous', 'Bonjour' and sometimes 'ZeroConf')
and is very convenient.

This package provides complementary DNS tracking service.

%description -n lib%name
Libraries for use of avahi.

%description -n lib%name-glib
Libraries for easy use of avahi from glib applications.

%description -n lib%name-gobject
GObject'ified version of avahi API

%description -n lib%name-libevent
Libevent mainloop adapter for avahi.

%description -n lib%name-qt5
Libraries for easy use of avahi from Qt UI applications.

%description -n lib%name-ui
Libraries for easy use of avahi from Gtk UI applications.

%description -n python3-module-%name
Python bindings for Avahi.

%description bookmarks
A web service for listing HTTP services that are announced via mDNS/DNS-SD
using the Avahi daemon. %name opens a TCP socket on port 8080 and waits for
incoming HTTP connections returning a dynamic web site containing links
to all services of type _http._tcp on the LAN.
Point your browser to http://localhost:8080/ to make use of avahi-bookmarks.

%description tools
command-line utilitiesthat use avahi to browse and publish mDNS services and hosts.

%description ui
Various UI tools that use avahi to discover and use mDNS services and hosts.

%description -n lib%name-devel
Header files and libraries necessary for developing
programs using avahi.

# }}}

%prep
%setup
touch config.rpath

%build
%autoreconf
export PYTHON=%__python3
%configure \
    --localstatedir=%_var \
    --with-distro=altlinux \
    --enable-core-docs \
    --disable-mono \
    --disable-monodoc \
    --disable-compat-howl \
    --disable-qt3 \
    --disable-qt4 \
    --disable-static \
%if_with python
    --enable-python \
    --enable-python-dbus \
%else
    --disable-python \
    --disable-python-dbus \
%endif
%if_with mdns
    --enable-compat-libdns_sd \
%endif
    --with-systemdsystemunitdir=%_unitdir \
    --with-avahi-user=%avahi_user \
    --with-avahi-group=%avahi_user \
    --with-avahi-priv-access-group=%avahi_group_priv \
    --with-autoipd-user=%autoipd_user \
    --with-autoipd-group=%autoipd_user

%make_build

%install
%make_install DESTDIR=%buildroot \
    pythondir=%python3_sitelibdir \
    pyexecdir=%python3_sitelibdir \
    install

mkdir -p %buildroot%_var/resolv/var/avahi \
	%buildroot%_localstatedir/autoipd

ln -s resolv/var/avahi %buildroot%_var/avahi

mkdir -p %buildroot%_sysconfdir/hooks/resolv.conf.d
cat <<EOF > %buildroot%_sysconfdir/hooks/resolv.conf.d/reload_avahi-daemon
#!/bin/sh

service messagebus status >/dev/null 2>&1 && service avahi-daemon condreload >/dev/null 2>&1 ||:
EOF

find %buildroot%_libdir -name '*.la' -delete
%find_lang %name
%if_with python
desktop-file-install --dir %buildroot%_desktopdir \
	--add-category=RemoteAccess \
	%buildroot%_desktopdir/avahi-discover.desktop
%endif
desktop-file-install --dir %buildroot%_desktopdir \
	--add-category=RemoteAccess \
	%buildroot%_desktopdir/bvnc.desktop
desktop-file-install --dir %buildroot%_desktopdir \
	--add-category=RemoteAccess \
	%buildroot%_desktopdir/bssh.desktop

%pre autoipd
/usr/sbin/groupadd -r -f %autoipd_user &>/dev/null ||:
/usr/sbin/useradd -r -g %autoipd_user -d %_localstatedir/autoipd -s /dev/null \
    -c "Avahi autoipd service" -M -n %autoipd_user &>/dev/null ||:

%pre daemon
/usr/sbin/groupadd -r -f %avahi_user &>/dev/null ||:
/usr/sbin/useradd -r -g %avahi_user -d %_var/run/avahi-daemon -s /dev/null \
    -c "Avahi service" -M -n %avahi_user &>/dev/null ||:

%post daemon
%post_service avahi-daemon
/sbin/service avahi-dnsconfd condrestart 2>/dev/null ||:
if /sbin/service messagebus status &>/dev/null; then
dbus-send --system --type=method_call --dest=org.freedesktop.DBus / org.freedesktop.DBus.ReloadConfig &>/dev/null ||:
else
echo "Avahi requires running messagebus service." >&2
fi

%preun daemon
%preun_service avahi-daemon

%add_python3_req_skip anydbm
%set_python3_req_method strict

%files

%files daemon
%doc docs/* specs

%_initdir/avahi-daemon

%_unitdir/avahi-daemon.service
%_unitdir/avahi-daemon.socket

%dir %_sysconfdir/avahi

%config %_sysconfdir/avahi/hosts

%config(noreplace) %_sysconfdir/avahi/avahi-daemon.conf

%dir %_sysconfdir/avahi/services
%config %_sysconfdir/avahi/services/ssh.service
%exclude %_sysconfdir/avahi/services/sftp-ssh.service

%attr(755, root, root) %_sysconfdir/hooks/resolv.conf.d/reload_avahi-daemon

%_sbindir/avahi-daemon

%_datadir/dbus-1/system.d/avahi-dbus.conf
%_datadir/dbus-1/system-services/org.freedesktop.Avahi.service

%_datadir/avahi/*
%exclude %_datadir/avahi/interfaces

%_man5dir/*
%_man8dir/avahi-daemon.*

%_var/avahi
%attr(0771, root, _avahi) %dir /var/resolv/var/avahi

%files autoipd
%dir %_sysconfdir/avahi
%config(noreplace) %_sysconfdir/avahi/avahi-autoipd.action
%_sbindir/avahi-autoipd
%_man8dir/avahi-autoipd.*
%attr(0771, root, %autoipd_user) %dir %_localstatedir/autoipd

%files dnsconfd
%_initdir/avahi-dnsconfd
%_unitdir/avahi-dnsconfd.service
%config(noreplace) %_sysconfdir/avahi/avahi-dnsconfd.action
%_sbindir/avahi-dnsconfd
%_man8dir/avahi-dnsconfd.*

%files -n lib%name -f %name.lang
%_libdir/libavahi-common.so.*
%_libdir/libavahi-core.so.*
%_libdir/libavahi-client.so.*

%if_with mdns
%_libdir/libdns_sd.so.*
%endif

%dir %_datadir/avahi
%dir %_datadir/avahi/interfaces

%dir %_libdir/avahi
%_libdir/avahi/service-types.db

%if_with python
%files bookmarks
%_bindir/avahi-bookmarks
%_man1dir/avahi-bookmarks.*
%endif # python

%files tools
%_bindir/avahi-browse*
%_bindir/avahi-publish*
%_bindir/avahi-resolve*
%_bindir/avahi-set-host-name

%_man1dir/avahi-browse*
%_man1dir/avahi-publish*
%_man1dir/avahi-resolve*
%_man1dir/avahi-set-host-name.*

%if_with python
%files ui
%_bindir/bshell
%_bindir/bssh
%_bindir/bvnc
%_bindir/avahi-discover
%_bindir/avahi-discover-standalone

%_datadir/avahi/interfaces/avahi-discover.ui

%_desktopdir/avahi-discover.desktop
%_desktopdir/bssh.desktop
%_desktopdir/bvnc.desktop

%_man1dir/bshell.*
%_man1dir/bssh.*
%_man1dir/bvnc.*
%_man1dir/avahi-discover.*
%endif #python

%files -n lib%name-glib
%_libdir/libavahi-glib.so.*

%files -n lib%name-gobject
%_libdir/libavahi-gobject.so.*

%files -n lib%name-libevent
%_libdir/libavahi-libevent.so.*

%files -n lib%name-qt5
%_libdir/libavahi-qt5.so.*

%files -n lib%name-ui
%_libdir/libavahi-ui-gtk3.so.*

%if_with python
%files -n python3-module-%name
%python3_sitelibdir/%name
%endif

%files -n lib%name-devel
%_includedir/avahi-client
%_includedir/avahi-common
%_includedir/avahi-core
%_includedir/avahi-glib
%_includedir/avahi-gobject
%_includedir/avahi-libevent
%_includedir/avahi-qt5
%_includedir/avahi-ui
%if_with mdns
%_includedir/avahi-compat-libdns_sd
%endif

%_datadir/dbus-1/interfaces/*

%_libdir/libavahi-common.so
%_libdir/libavahi-core.so
%_libdir/libavahi-client.so
%_libdir/libavahi-glib.so
%_libdir/libavahi-gobject.so
%_libdir/libavahi-libevent.so
%_libdir/libavahi-ui-gtk3.so
%_libdir/libavahi-qt5.so
%if_with mdns
%_libdir/libdns_sd.so
%endif

%_pkgconfigdir/avahi-core.pc
%_pkgconfigdir/avahi-client.pc
%_pkgconfigdir/avahi-glib.pc
%_pkgconfigdir/avahi-gobject.pc
%_pkgconfigdir/avahi-libevent.pc
%_pkgconfigdir/avahi-ui-gtk3.pc
%_pkgconfigdir/avahi-qt5.pc
%if_with mdns
%_pkgconfigdir/avahi-compat-libdns_sd.pc
%endif

%changelog
