Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires: rpm-build-java unzip
# END SourceDeps(oneline)
BuildRequires: /proc
BuildRequires: jpackage-default
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           avalon-logkit
Epoch:          0
Version:        2.1
Release:        alt2_32jpp11
Summary:        Java logging toolkit
License:        ASL 2.0
URL:            http://avalon.apache.org/
BuildArch:      noarch

Source0:        http://archive.apache.org/dist/excalibur/%{name}/source/%{name}-%{version}-src.zip

Patch0001:      0001-Port-build-script-to-Maven-3.patch
Patch0002:      0002-Port-to-Java-7.patch
Patch0003:      0003-Fix-encoding.patch

BuildRequires:  maven-local
BuildRequires:  mvn(javax.mail:mail)
BuildRequires:  mvn(javax.servlet:servlet-api)
BuildRequires:  mvn(junit:junit)
BuildRequires:  mvn(log4j:log4j)
BuildRequires:  mvn(org.apache.felix:maven-bundle-plugin)
BuildRequires:  mvn(org.apache.geronimo.specs:geronimo-jms_1.1_spec)

Provides:       deprecated()
Source44: import.info

%description
LogKit is a logging toolkit designed for secure performance orientated
logging in applications. To get started using LogKit, it is recomended
that you read the whitepaper and browse the API docs.

%package javadoc
Group: Development/Java
Summary:        Javadoc for %{name}
Provides:       deprecated()
BuildArch: noarch

%description javadoc
Javadoc for %{name}.

%prep
%setup -q
%patch1 -p1
%patch2 -p1
%patch3 -p1
mv project.xml pom.xml

# LogFactor5 is no longer distributed with log4j
%pom_remove_dep log4j:log4j
rm -rf src/java/org/apache/log/output/lf5

%mvn_file : %{name}
%mvn_alias : logkit:logkit

# Add proper Apache Felix Bundle Plugin instructions
# so that we get a reasonable OSGi manifest.
%pom_xpath_inject pom:project "<packaging>bundle</packaging>"
%pom_xpath_inject pom:build "
  <plugins>
    <plugin>
      <groupId>org.apache.felix</groupId>
      <artifactId>maven-bundle-plugin</artifactId>
      <extensions>true</extensions>
      <configuration>
        <instructions>
          <Bundle-SymbolicName>avalon-logkit-2.1</Bundle-SymbolicName>
          <_nouses>true</_nouses>
        </instructions>
      </configuration>
    </plugin>
  </plugins>"

%build
%mvn_build -- -Dmaven.compiler.source=1.8 -Dmaven.compiler.target=1.8 -Dmaven.javadoc.source=1.8 -Dmaven.compiler.release=8

%install
%mvn_install

%files -f .mfiles
%doc --no-dereference LICENSE.txt NOTICE.txt

%files javadoc -f .mfiles-javadoc
%doc --no-dereference LICENSE.txt NOTICE.txt

%changelog
