# -*- rpm-spec -*-
# $Id: avrdude,v 1.2 2005/02/02 09:35:55 grigory Exp $

%def_enable doc
%def_enable parport

%define udev_rules_file 70-avrdude_usbprog.rules
%set_verify_elf_method unresolved=relaxed

%global optflags_lto %nil

Summary: AVRDUDE is software for programming Atmel AVR Microcontrollers.
Name: avrdude
Version: 6.3
Release: alt6
License: GPL
Group: Development/Other
URL: http://www.nongnu.org/avrdude/
Source0: http://download.savannah.gnu.org/releases/avrdude/%name-%version.tar.gz
Source3: modprobe.avrdude_parport
##############################
## use to convert avrdude-udev-rules(fedora), debian.avrdude.udev
Source2: udevrules2table.pl
# SuSE 6.3-3.4
Source4: avrdude-usbdevices
# fedora 6.3-17
Source5: avrdude-udev-rules
# debian ???
Source6: debian.avrdude.udev
## merge avrdude-usbdevices(suse), converted avrdude-udev-rules & debian.avrdude.udev
## into avrdude-usbdevices.altmerged
Source7: avrdude-usbdevices.altmerged
##############################
Patch: avrdude-install-header.patch


BuildRequires: gnu-config libtinfo-devel libusb-devel libusb-compat-devel makeinfo
BuildRequires: flex libelf-devel libftdi1-devel libncurses-devel libreadline-devel

%if_enabled doc
BuildRequires: texlive-collection-latexrecommended texi2html texi2dvi
%endif

%package docs
Summary: Documentation for AVRDUDE.
Group: Development/Other
BuildArch: noarch

%package devel
Summary: The AVRDUDE static library with API for other tools.
Group: Development/C
Provides: lib%name-devel = %version-%release
Provides: lib%name-static = %version-%release

%description
AVRDUDE is software for programming Atmel AVR Microcontrollers.

%description docs
Documentation for avrdude in html, postscript and pdf formats.

%description devel
AVRDUDE static library provides API integration for programming Atmel AVR Microcontrollers.

%prep
%setup -q
%patch -p2
# useful cleanups based on fedora spec
chmod -x safemode.c doc/TODO
sed -i 's|/usr/local/etc/avrdude.conf|/etc/avrdude.conf|g' doc/avrdude.texi avrdude.1
iconv -f ISO88591 -t UTF8 -o ChangeLog-2003 < ChangeLog-2003
iconv -f ISO88591 -t UTF8 -o NEWS < NEWS

%build
%autoreconf
%configure %{subst_enable doc} %{subst_enable parport} --enable-linuxgpio
%make

%install
%makeinstall
sed -i 's/^#include "ac_cfg\.h"$/#include <libavrdude_cfg.h>/' %buildroot%_includedir/libavrdude.h
install -T ac_cfg.h %buildroot%_includedir/libavrdude_cfg.h
rm -f %buildroot%_libdir/*.so*

%global udevdir %{_prefix}/lib/udev
%global tag uaccess
RULESFILE=%buildroot%_udevrulesdir/%udev_rules_file
mkdir -p ${RULESFILE%/*}
while IFS=" " read major minor comment;do
    echo "# $comment"
    echo 'SUBSYSTEM=="usb", ATTRS{idVendor}=="'$major'", ATTRS{idProduct}=="'$minor'", TAG+="%{tag}"'
done <%{SOURCE7} >> $RULESFILE
chmod 644 $RULESFILE


%if_enabled parport
install -D -m 644 %{SOURCE3} %buildroot%_sysconfdir/modprobe.d/50-avrdude_parport.conf
%endif

%if_enabled doc
%post

%preun
%endif

%files
%doc AUTHORS ChangeLog* NEWS README doc/TODO
%config %_sysconfdir/%name.conf
%_bindir/*
%_man1dir/*
%_udevrulesdir/%udev_rules_file
%if_enabled parport
%dir %{_sysconfdir}/modprobe.d
%config %{_sysconfdir}/modprobe.d/50-avrdude_parport.conf
%endif

%if_enabled doc
%_infodir/*

%files docs
%doc doc/avrdude-html/*.html doc/avrdude.ps doc/avrdude.pdf
%endif

%files devel
%_includedir/*.h
%_libdir/*.a

%changelog
