Name: awesome
Version: 4.3
Release: alt5
Group: Graphical desktop/Other
License: %gpl2plus

Url: https://awesomewm.org/
Packager: Evgenii Terechkov <evg@altlinux.org>
Source: %name-%version.tar
Source1: %name.wmsession
Source2: %name.menu-method
Patch0:%name-%version-alt.patch

Summary: A window manager initialy based on a dwm code rewriting

BuildRequires: ImageMagick-tools asciidoctor cmake gcc-c++ gperf
BuildRequires: imlib2-devel libdbus-devel libev-devel liblua5.3-devel
BuildRequires: libncurses-devel libpango-devel libreadline-devel xmlto
BuildRequires: libxdg-basedir-devel libstartup-notification-devel
BuildRequires: libXdmcp-devel libgdk-pixbuf-devel lgi
BuildRequires: lua5.3 libpango-gir libgdk-pixbuf-gir libcairo-gobject
BuildRequires: libpcre-devel libxkbcommon-devel libxkbcommon-x11-devel libxcbutil-xrm-devel

BuildRequires(pre): libxcbutil-devel >= 0.3.8 libxcbutil-keysyms-devel >= 0.3.8
BuildRequires(pre): libxcbutil-icccm-devel >= 0.3.8 libxcbutil-cursor-devel
BuildRequires(pre): rpm-build-licenses

Requires: libstartup-notification >= 0.10-alt1
Requires: lgi >= 0.9.1
Requires: libpango-gir
Requires: libcairo-gobject
Requires: libgdk-pixbuf-gir

%description
awesome is a window manager initialy based on a dwm code rewriting. It's
extremely fast, small, dynamic and awesome.

%prep
%setup -n %name-%version
%patch0 -p1

%build
echo -n "v%version" >| .version_stamp
mkdir -p build
pushd build
CFLAGS="%optflags" \
CXXFLAGS="%optflags" \
cmake \
  -Wno-dev \
  -DPREFIX=%prefix \
  -DAWESOME_DOC_PATH=%_docdir/%name-%version \
  -DCMAKE_INSTALL_PREFIX=%prefix \
  -DSYSCONF_INSTALL_DIR=%_sysconfdir \
  -DSYSCONFDIR=%_sysconfdir \
  -DCOMPRESS_MANPAGES=OFF \
%if %_lib == lib64
  -DLIB_SUFFIX=64 \
%endif
  ..

%make_build
popd

%install

%add_findreq_skiplist %_datadir/%name/*
# ugly workaround :(
%filter_from_requires /lua.*\(awful.*\|beautiful\|gears\|menubar\|naughty\|wibox\)/d

pushd build
# Fix manpages:
for i in `find manpages -type f -iname '*.[0-9]'`; do
    sed -i '1i.\\" -*- mode: troff; coding: utf-8 -*-' $i
# "
done

%makeinstall DESTDIR=%buildroot install
popd
install -D -m 644 %name.desktop %buildroot/%_desktopdir/%name.desktop
touch %buildroot%_sysconfdir/xdg/%name/menu.lua
install -D -m 644 %SOURCE1 %buildroot%_sysconfdir/X11/wmsession.d/05%name
install -D -m 755 %SOURCE2 %buildroot%_sysconfdir/menu-methods/%name

%find_lang %name

%files -f %name.lang
%_bindir/*
%_sysconfdir/menu-methods/%name
%_sysconfdir/xdg/%name
%ghost %_sysconfdir/xdg/%name/menu.lua
%_sysconfdir/X11/wmsession.d/*
%_man1dir/aw*
%_man5dir/aw*
%_mandir/*/man1/aw*
%_mandir/*/man5/aw*
%_datadir/%name
%_desktopdir/%name.desktop
%_datadir/xsessions/%name.desktop
%doc LICENSE build/docs/*.md

%changelog
