%define _unpackaged_files_terminate_build 1
%define _libexecdir %_prefix/libexec

Name: ayatana-indicator-printers
Version: 23.10.1
Release: alt1

Summary: Ayatana Indicator showing active print jobs
License: GPLv3
Group: Graphical desktop/Other
Url: https://github.com/AyatanaIndicators/ayatana-indicator-printers

Source: %name-%version.tar

BuildRequires(pre): rpm-macros-cmake
BuildRequires(pre): rpm-macros-systemd

BuildRequires: ayatana-cmake-modules
BuildRequires: ayatana-indicator-common
BuildRequires: cmake
BuildRequires: intltool
BuildRequires: libaccounts-glib-devel
BuildRequires: libayatana-common-devel
BuildRequires: libcups-devel
BuildRequires: libdbus-devel
BuildRequires: libdbusmenu-gtk3-devel
BuildRequires: libpcre2-devel
BuildRequires: libsystemd-devel

%description
This Ayatana Indicator is designed to let you view and control
active print jobs.

Use an indicator plugin for your desktop environment or a desktop
environment that natively supports indicators to provide this
indicator to the user.

%prep
%setup

%build
%cmake \
  -DCMAKE_INSTALL_LOCALSTATEDIR=%_localstatedir \
  -Denable_tests=Off \
  -Denable_lomiri_features=Off
%cmake_build

%install
%cmake_install

find %buildroot -type f -name "*.la" -delete -print

# these translations are ignored by %%find_lang
rm -fv %buildroot%_datadir/locale/it_CARES/LC_MESSAGES/%name.mo
rm -fv %buildroot%_datadir/locale/zh_LATN@pinyin/LC_MESSAGES/%name.mo

%find_lang %name

%post
%systemd_user_post %name.service

%preun
%systemd_user_preun %name.service

%postun
%systemd_user_postun %name.service

%files -f %name.lang
%doc COPYING AUTHORS AUTHORS.Canonical NEWS README
%config %_sysconfdir/xdg/autostart/%name.desktop
%dir %_libexecdir/%name/
%_libexecdir/%name/%{name}-service
%_datadir/ayatana/indicators/org.ayatana.indicator.printers
%_userunitdir/%name.service

%changelog
