%def_enable snapshot

%define ver_major 0.18
%define beta %nil
%define pypi_name blueprintcompiler
%def_enable docs
%def_enable check

Name: blueprint-compiler
Version: %ver_major.0
Release: alt1%beta

Summary: A markup language for GTK user interface files
Group: Development/GNOME and GTK+
License: GPL-3.0-or-later
Url: https://gitlab.gnome.org/jwestman/blueprint-compiler

Vcs: https://gitlab.gnome.org/jwestman/blueprint-compiler.git

%if_disabled snapshot
Source: %url/-/archive/v%version/%name-%version%beta.tar.bz2
%else
Source: %name-%version%beta.tar
%endif

BuildArch: noarch

Requires: typelib(GIRepository) = 2.0
Requires: typelib(GIRepository) = 3.0
Requires: typelib(Adw) = 1

BuildRequires(pre): rpm-macros-meson rpm-build-python3 rpm-build-gir
BuildRequires: meson
%{?_enable_check:BuildRequires: xvfb-run /usr/bin/dbus-launch python3-module-pygobject3
BuildRequires: fontconfig at-spi2-core typelib(Adw) = 1}
%{?_enable_docs:BuildRequires: /usr/bin/sphinx-build-3 python3(sphinx_basic_ng) python3(furo)}

%description
%summary
See also https://jwestman.pages.gitlab.gnome.org/blueprint-compiler/

%prep
%setup -n %name-%version%beta
# https://gitlab.gnome.org/jwestman/blueprint-compiler/-/issues/178
#rm -r tests/sample_errors/deprecations.*

%build
%meson \
    %{subst_enable_meson_bool docs docs}
%nil
%meson_build
%if_enabled docs
pushd docs
meson compile docs -C ../%__builddir
popd
%endif

%install
%meson_install
%find_lang %name
%if_enabled docs
cp -a %__builddir/docs/en html
%endif

%check
xvfb-run %__meson_test -t 2

%files -f %name.lang
%_bindir/%name
%python3_sitelibdir_noarch/%pypi_name/
%_datadir/pkgconfig/%name.pc
%doc NEWS* README* %{?_enable_docs:html/}

%changelog
