Name:     bookworm
Version:  1.1.2
Release:  alt4

Summary:  Simple, focused eBook reader

License:  GPLv3
Group:    Office
URL:      https://github.com/babluboy/bookworm

# Source-git: https://github.com/babluboy/bookworm.git
Source:  %name-%version.tar

Patch1: %name-%version.patch

BuildRequires(pre): rpm-build-python3
BuildRequires(pre): meson
BuildRequires: libgranite-devel
BuildRequires: libgranite-vala
BuildRequires: libgee0.8-devel
BuildRequires: libpoppler-glib-devel
BuildRequires: libvala-devel vala
BuildRequires: libwebkit2gtk-devel
BuildRequires: desktop-file-utils
BuildRequires: libappstream-glib
BuildRequires: appstream-devel
BuildRequires: libxml2-devel
BuildRequires: libsqlite3-devel

Requires: icon-theme-hicolor

%description
Read the books you love without having to worry about the different
format complexities like epub, pdf, mobi, cbr, etc. This version
supports EPUB, MOBI, FB2, PDF, FB2 and Comics (CBR and CBZ) formats
with support for more formats to follow soon.

%prep
%setup -q -n %name-%version
%patch1 -p1
# add python3 support fix
sed -i 's|#!.*python.*$|#!/usr/bin/python3|' $(grep -Rl '#!.*python.*$' *)
find . -name '*.pyc' -print -delete
# fix *.py files permissions
( cd %_builddir/%name-%version/data/scripts/mobi_lib
	chmod 644 *.py
)

%build
%meson
%meson_build

%install
%meson_install
%find_lang com.github.babluboy.bookworm
desktop-file-validate %buildroot%_desktopdir/com.github.babluboy.bookworm.desktop
appstream-util validate-relax --nonet %buildroot%_datadir/metainfo/com.github.babluboy.bookworm.appdata.xml
( cd %buildroot%_bindir
  ln -s com.github.babluboy.bookworm bookworm
)

%__python3 -m compileall %buildroot%_datadir

%files -f com.github.babluboy.bookworm.lang
%_bindir/com.github.babluboy.bookworm
%_bindir/bookworm
%_datadir/com.github.babluboy.bookworm/
%_desktopdir/com.github.babluboy.bookworm.desktop
%_datadir/glib-2.0/schemas/com.github.babluboy.bookworm.gschema.xml
%_iconsdir/hicolor/*/apps/com.github.babluboy.bookworm.svg
%_datadir/metainfo/com.github.babluboy.bookworm.appdata.xml
%doc README.md

%changelog
