Name: borg
Version: 1.2.7
Release: alt1

Summary: Deduplicating backup program with compression and authenticated encryption

License: BSD-3-Clause
Group: File tools
Url: https://borgbackup.github.io/borgbackup/

# Source-url: https://github.com/borgbackup/borg/archive/%version.tar.gz
Source: %name-%version.tar
Patch1: borg-unbundle-xxhash-1.1.10.patch

BuildRequires(pre): rpm-build-python3

BuildRequires: gcc-c++
BuildRequires: libacl-devel ipython3 python3-module-Cython libssl-devel python3-dev
BuildRequires: python3-module-setuptools-wheel python3-module-setuptools_scm python3-module-pytest python3-module-msgpack python3-module-pkgconfig
BuildRequires: liblz4-devel libzstd-devel libb2-devel libxxhash-devel

Requires: python3-module-zmq python3-module-msgpack

%description
BorgBackup (short: Borg) is a deduplicating backup program.
Optionally, it supports compression and authenticated encryption.

The main goal of Borg is to provide an efficient and secure way to backup data.
The data deduplication technique used makes Borg suitable for daily backups
since only changes are stored.

The authenticated encryption technique makes it suitable for backups to not
fully trusted targets.

%prep
%setup
#patch1 -p1

#rm -rfv src/borg/algorithms/{lz4,xxh64,zstd,blake2}/
#rm -rfv src/borg/algorithms/{lz4,zstd,blake2}/

%build
export SETUPTOOLS_SCM_PRETEND_VERSION=%version
export BORG_OPENSSL_PREFIX="/usr/include/openssl"
#pyproject_build
%python3_build

%install
export SETUPTOOLS_SCM_PRETEND_VERSION=%version
export BORG_OPENSSL_PREFIX="/usr/include/openssl"
#pyproject_install
%python3_install

%check
export LANG=en_US.UTF-8
#export PYTHONPATH="$(pwd)/build/lib.linux-$(uname -m)-%__python3_version"
export PYTHONVER="%__python3_version"
export PYTHONPATH="$(pwd)/build/lib.linux-$(uname -m)-cpython-${PYTHONVER//./}"

# copy missing files
cp -a src/borg/testsuite/attic.tar.gz $PYTHONPATH/borg/testsuite/
cp -a src/borg/paperkey.html $PYTHONPATH/borg

TEST_SELECTOR="not test_fuse and not test_readonly_mount and not benchmark"
py.test-3 -x -vk "$TEST_SELECTOR" $PYTHONPATH/borg/testsuite/*.py

%files
%doc LICENSE AUTHORS CHANGES.rst README.rst
%_bindir/borg
%_bindir/borgfs
%python3_sitelibdir/borg/
%python3_sitelibdir/borgbackup-*.egg-info/


%changelog
