# SPDX-License-Identifier: GPL-2.0-only
%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict,lint=relaxed

%ifarch loongarch64
# XXX: only lld supports thin LTO. However
# - as of LLVM 16 lld does not support LoongArch targets at all
# - as of LLVM 17 lld does not support LoongArch relocations properly
#   and is unable to link with libraries produced by GNU ld (i.e. glibc)
%def_without lld
%define optflags_lto %nil
%else
%def_with lld
%define optflags_lto -flto=thin
%endif

# Based on https://github.com/iovisor/bpftrace/blob/master/INSTALL.md

Name: bpftrace
Version: 0.20.3
Release: alt2
Summary: High-level tracing language for Linux eBPF
Group: Development/Debuggers
License: Apache-2.0
URL: https://github.com/iovisor/bpftrace
# Docs: https://github.com/iovisor/bpftrace/blob/master/docs/reference_guide.md
# Docs: https://github.com/iovisor/bpftrace/blob/master/docs/tutorial_one_liners.md
# Docs: http://www.brendangregg.com/BPF/bpftrace-cheat-sheet.html
# Docs: http://www.brendangregg.com/ebpf.html#bpftrace
# PR: https://lwn.net/Articles/793749/
# PR: http://www.brendangregg.com/blog/2018-10-08/dtrace-for-linux-2018.html

Source: %name-%version.tar
# Submodules are maintained with gear-submodule-update.
Source1: bcc-0.tar
Source2: blazesym-0.tar
Source3: bpftool-0.tar
Source4: libbpf-0.tar
Source5: libbpf-1.tar
Source6: libbpf-2.tar
ExclusiveArch:	x86_64 aarch64 loongarch64

%define llvm_ver 17
%define llvm_pkgver %llvm_ver.0
BuildRequires(pre): rpm-macros-cmake
BuildRequires: binutils-devel
BuildRequires: cereal-devel
BuildRequires: clang%llvm_pkgver-devel
BuildRequires: cmake
BuildRequires: flex
BuildRequires: libbcc-devel
BuildRequires: libbpf-devel
BuildRequires: libdw-devel
BuildRequires: libelf-devel
BuildRequires: libpcap-devel
BuildRequires: libstdc++-devel
BuildRequires: libstdc++-devel-static
%if_with lld
BuildRequires: lld%llvm_pkgver
%endif
BuildRequires: llvm%llvm_pkgver-devel
BuildRequires: /proc
BuildRequires: python3-module-setuptools
# Assuming 'kernel' dependency will bring un-def kernel
%{?!_without_check:%{?!_disable_check:
BuildRequires: kernel-headers-modules-un-def
BuildRequires: rpm-build-vm
}}

%description
bpftrace is a high-level tracing language for Linux enhanced Berkeley
Packet Filter (eBPF) available in recent Linux kernels (4.x). bpftrace
uses LLVM as a backend to compile scripts to BPF-bytecode and makes use of
BCC for interacting with the Linux BPF system, as well as existing Linux
tracing capabilities: kernel dynamic tracing (kprobes), user-level dynamic
tracing (uprobes), and tracepoints. The bpftrace language is inspired by
awk and C, and predecessor tracers such as DTrace and SystemTap. bpftrace
was created by Alastair Robertson.

%prep
%setup
tar xf %SOURCE1 -C .
tar xf %SOURCE2 -C bcc/libbpf-tools
tar xf %SOURCE3 -C bcc/libbpf-tools
tar xf %SOURCE4 -C bcc/libbpf-tools/bpftool
tar xf %SOURCE5 -C bcc/src/cc
tar xf %SOURCE6 -C .
sed -i 's/\bpython\b/python3/' tests/runtime/call
sed -i 's/@.*@/True/' tests/runtime/engine/cmake_vars.py

%build
%remove_optflags -frecord-gcc-switches
export CC=clang-%llvm_ver
export CXX=clang++-%llvm_ver
%if_with lld
export LDFLAGS="-fuse-ld=lld $LDFLAGS"
%endif
export Clang_DIR=/usr/share/cmake/Modules/clang
# -DBUILD_TESTING:BOOL=ON will require googletest and try to clone it from github
%cmake \
	-DCMAKE_BUILD_TYPE=RelWithDebInfo \
	-DBUILD_TESTING:BOOL=OFF \
	-DBUILD_SHARED_LIBS:BOOL=OFF \
	-DLLVM_DIR=$(llvm-config-%llvm_ver --cmakedir) \
	-DLLVM_REQUESTED_VERSION=%llvm_ver \
	-DOFFLINE_BUILDS:BOOL=ON \
	-DALLOW_UNSAFE_PROBE:BOOL=ON \
	-DUSE_SYSTEM_BPF_BCC:BOOL=ON \
	%nil
%cmake_build

%install
%cmake_install
find %buildroot%_datadir/%name/tools -name '*.bt' | xargs chmod a+x

# Fix man pages.
pushd %buildroot%_man8dir
 rename '' bpftrace- *.gz
popd

# Need to keep BEGIN_trigger and END_trigger
# https://github.com/iovisor/bpftrace/issues/954
%brp_strip_debug %_bindir/bpftrace

%check
%_cmake__builddir/src/bpftrace --version	 # not requires root
vm-run %_cmake__builddir/src/bpftrace --info # should be fast enough even w/o kvm
vm-run --kvm=cond %_cmake__builddir/src/bpftrace -l 'kprobe:*_sleep_*'
if kvm-ok; then
	## Great run-time tests

	# Some fail due to no BUILD_TESTING
	.gear/delete-blocks syscalls:	tests/runtime/*
	.gear/delete-blocks testprogs	tests/runtime/*
	.gear/delete-blocks uprobe	tests/runtime/*
	.gear/delete-blocks usdt	tests/runtime/usdt
	.gear/delete-blocks vfs_read	tests/runtime/*     # TIMEOUT
	.gear/delete-blocks hardware	tests/runtime/probe # TIMEOUT
	.gear/delete-blocks k.*_order	tests/runtime/probe # TIMEOUT
	.gear/delete-blocks watchpoint:	tests/runtime/watchpoint
	.gear/delete-blocks string_args	tests/runtime/other
	.gear/delete-blocks interval_order tests/runtime/probe
	.gear/delete-blocks tracepoint_order tests/runtime/probe
	.gear/delete-blocks uint64_t	tests/runtime/signed_ints
	.gear/delete-blocks tracepoint:random:random_read tests/runtime/variable
	.gear/delete-blocks tracepoint:sched:sched_wakeup tests/runtime/regression
	.gear/delete-blocks histogram-finegrain tests/runtime/json-output
%ifarch aarch64
	# TIMEOUT on aarch64
	.gear/delete-blocks python	tests/runtime/json-output
%endif
	export BPFTRACE_RUNTIME_TEST_EXECUTABLE=$PWD/%_cmake__builddir/src/bpftrace
	sed -i 's/xattr.h/user.h/' tests/runtime/basic
	vm-run --kvm=cond --sbin tests/runtime-tests.sh
fi

%files
%define _customdocdir %_docdir/%name
%doc LICENSE README.md CHANGELOG.md CONTRIBUTING-TOOLS.md
%doc docs/reference_guide.md docs/tutorial_one_liners.md
%_bindir/*
%_datadir/%name
%_man8dir/*

%changelog
