%define _unpackaged_files_terminate_build 1

# XXX: python3.req.py has to deal with this in an ideal world.
# The following Python modules are autogenerated by Qt UIC.
%filter_from_requires '/^python3\(ui_/d'
# The following Python modules are seemingly autoprovided by Carla.
%filter_from_requires '/^python3\(modtools/d'

Name: carla
Version: 2.5.8
Release: alt1

Summary: A featureful audio plugin host

License: GPL-2.0-or-later
Group: Sound
URL: https://kx.studio/Applications:Carla

Source: %name-%version.tar
# part of upstream/hotfix-2.5
Patch1: 0001-Adjust-for-liblo-API-breakage-dont-define-lo_message.patch

BuildRequires: rpm-build-python3
BuildRequires: make gcc-c++
BuildRequires:  pkgconfig(alsa)
BuildRequires:  pkgconfig(libpulse)
BuildRequires:  pkgconfig(jack)
BuildRequires:  pkgconfig(sndfile)
BuildRequires:  pkgconfig(gtk+-2.0)
BuildRequires:  pkgconfig(gtk+-3.0)
BuildRequires:  pkgconfig(Qt5Core)
BuildRequires:  pkgconfig(Qt5Gui)
BuildRequires:  python3(PyQt5.pyrcc)
BuildRequires:  pkgconfig(fluidsynth)
BuildRequires:  pkgconfig(fftw3)
BuildRequires:  pkgconfig(mxml)
BuildRequires:  pkgconfig(gl)
BuildRequires:  pkgconfig(liblo)
BuildRequires:  pkgconfig(zlib)
BuildRequires:  libmagic-devel
BuildRequires:  python3(magic)

%description
Carla is an audio plugin host, with support for many audio drivers and plugin
formats. It has some nice features like automation of parameters via MIDI CC
and full OSC control. Currently supports LADSPA, DSSI, LV2, VST2/3 and AU
plugin formats, as well as GIG, SF2 and SFZ sounds banks.

%package vst
Summary: Carla VST plugins
Group: Sound

%description vst
This package contains the Carla VST plugins, including Rack and Patchbay.

%package -n lv2-carla
Summary: Carla LV2 plugin
Group: Sound

%description -n lv2-carla
This package contains the Carla LV2 plugin.

%package devel
Summary: Development files for carla
Group: Development/C

%description devel
This package includes development files for libcarla.

%prep
%setup
%patch1 -p1

%ifarch %e2k
%add_optflags -mno-sse
echo > source/modules/ysfx/sources/eel2-gas/sources/asm-nseel-x64-sse.S
%endif

rm -rf data/{macos,windows}

sed -E -i '/^PREFIX[[:space:]]+/s|^.*$|PREFIX := %_prefix # set by ALT spec|' Makefile

# Make python components use system python3.
find . -type f \( -name "*.py" \) -exec sed -i "s|#!/usr/bin/env python3|#!%__python3|g" {} \;
sed -i "s|#!/usr/bin/env python3|#!%__python3|g" source/frontend/{carla,carla-control,carla-jack-multi,carla-jack-single,carla-patchbay,carla-rack}
# This file is marked /usr/bin/env python for some reason.
sed -i "s|#!/usr/bin/env python|#!%__python3|g" source/frontend/widgets/paramspinbox.py

%build
make features # log build configuration
%make_build PREFIX="%_prefix" LIBDIR="%_libdir" \
    SKIP_STRIPPING=true V=1

%install
%makeinstall_std PREFIX="%_prefix" LIBDIR="%_libdir"

%check

%files
%doc README.md
%_bindir/carla
%_bindir/carla-control
%_bindir/carla-database
%_bindir/carla-jack-multi
%_bindir/carla-jack-single
%_bindir/carla-patchbay
%_bindir/carla-rack
%_bindir/carla-settings
%_bindir/carla-single
%_bindir/carla-jack-patchbayplugin
%_bindir/carla-osc-gui
%_libdir/carla
%_datadir/carla
%_datadir/applications/carla.desktop
%_datadir/applications/carla-control.desktop
%_datadir/applications/carla-jack-multi.desktop
%_datadir/applications/carla-jack-single.desktop
%_datadir/applications/carla-patchbay.desktop
%_datadir/applications/carla-rack.desktop
%_datadir/icons/hicolor/*/apps/carla*.png
%_datadir/icons/hicolor/*/apps/carla*.svg
%_datadir/mime/packages/carla.xml
%_datadir/appdata/studio.kx.carla.appdata.xml

%files vst
%_libdir/vst/

%files -n lv2-carla
%_libdir/lv2/carla.lv2

%files devel
%_includedir/carla
%_pkgconfigdir/carla-*.pc

%changelog
