%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1

Name:    castxml
Version: 0.6.10
Release: alt1

Summary: C-family abstract syntax tree XML output tool

Group:   Development/Other
License: Apache-2.0
URL:     https://github.com/CastXML/CastXML

Source:	%name-%version.tar

BuildRequires(pre): rpm-macros-cmake

BuildRequires: cmake ctest gcc-c++
BuildRequires: llvm-devel
BuildRequires: clang-devel
# requires clang-format, which is in clang-tools
BuildRequires: clang-tools
BuildRequires: libedit-devel
BuildRequires: zlib-devel
BuildRequires: /usr/bin/sphinx-build
BuildRequires: libxml2-devel libtinfo-devel libffi-devel

Requires: /proc

Obsoletes: gccxml

%description
Parse C-family source files and optionally write a subset of the
Abstract Syntax Tree (AST) to a representation in XML.

Source files are parsed as complete translation units using the clang
compiler. XML output is enabled by the --castxml-gccxml option and
produces a format close to that of gccxml. Future versions of castxml
may support alternative output formats.

%prep
%setup

%build
export CC=clang
export CXX=clang++

%cmake \
       -DLLVM_LINK_LLVM_DYLIB:BOOL=ON \
       -DCLANG_LINK_CLANG_DYLIB:BOOL=ON \
       -DCastXML_INSTALL_DOC_DIR:STRING=share/doc/%name \
       -DCastXML_INSTALL_MAN_DIR:STRING=share/man \
       -DCLANG_RESOURCE_DIR:PATH=$(clang -print-file-name=include)/.. \
       -DLLVM_LINK_LLVM_DYLIB:BOOL=ON \
       -DBUILD_TESTING:BOOL=ON \
       -DSPHINX_MAN:BOOL=ON \
       -DLLVM_DIR=$(llvm-config --cmakedir) \
       %nil

%cmake_build

%install
%cmake_install

rm -f %buildroot%_datadir/doc/%name/LICENSE
rm -f %buildroot%_datadir/doc/%name/NOTICE

%check
pushd %_cmake__builddir
ctest
popd

%files
%doc LICENSE
%doc NOTICE README.rst
%_bindir/castxml
%_man1dir/castxml.1*
%dir %_datadir/%name
%_datadir/%name/clang
%_datadir/%name/detect_vs.c
%_datadir/%name/detect_vs.cpp
%_datadir/%name/empty.c
%_datadir/%name/empty.cpp

%changelog
