# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/a2x
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           cclive
Version:        0.9.3
Release:        alt2
Summary:        Command line video extraction utility
Packager: Ilya Mashkin <oddity@altlinux.ru>
Group:          Video
License:        GPLv3+
URL:            http://cclive.sourceforge.net/
Source0:        http://downloads.sourceforge.net/%{name}/%{name}-%{version}.tar.xz

#SuSE
Patch0:         cclive-0.9.3_iostream.patch
Patch1:         cclive-0.9.3_gcc5.patch
Patch2:         cclive-0.9.3_subdir.patch
Patch4:         cclive-0.9.3_boost1.67.patch
# gentoo (not used)
Patch3:         %name-0.9.3-gentoo-boost-ver-check.patch

BuildRequires:  gcc-c++
BuildRequires:  boost-devel
BuildRequires:  boost-filesystem-devel
BuildRequires:  boost-program_options-devel
BuildRequires:  libquvi-devel
BuildRequires:  pkgconfig(glib-2.0) >= 2.24
BuildRequires:  pkgconfig(glibmm-2.4) >= 2.24
BuildRequires:  pkgconfig(libcurl) >= 7.18.0
BuildRequires:  pkgconfig(libpcre) >= 8.02
BuildRequires:  pkgconfig(libpcrecpp) >= 8.02

%description
cclive is a command line video extraction utility similar to clive but with
lower requirements. Its features are few and essential. Supports Youtube,
Googlevideo, Break, Liveleak, Sevenload, Evisortv and Dailymotion.

%prep
%setup -q
%patch0 -p1
%patch1 -p1
%patch2 -p1
%patch4 -p1
# gentoo (not used)
#patch3 -p1

%ifarch %e2k
# lcc 1.25.20: cpp adds an extra space breaking this regex (mcst#6826)
sed -i 's,\^boost-lib-version,boost-lib-version,' m4/boost.m4
%endif

%build
export DATE=/bin/true
autoreconf -fiv
%configure
%make_build

%install
%makeinstall_std

%files
%doc COPYING
%doc ChangeLog NEWS README
%{_bindir}/cclive
%{_bindir}/ccl
%{_man1dir}/cclive.1*

%changelog
