Name: celestia
Version: 1.6.2.2
Release: alt3
Epoch: 1

Summary: A real-time visual space simulation

License: GPL-2.0
Group: Education
Url: https://celestia.space

Requires: celestia-common
Provides: celestia-ui = %EVR
Provides: celestia-qt = %EVR celestia-gtk = %EVR celestia-glut = %EVR
Obsoletes: celestia-qt < %EVR celestia-gtk < %EVR celestia-glut < %EVR

# Source-url: https://github.com/CelestiaProject/Celestia/archive/master.zip
Source: %name-%version.tar

Patch: celestia-1.6.2.2-alt-lua5.4.patch

BuildRequires: cmake gcc-c++ libstdc++-devel
BuildRequires: libGLEW-devel libXi-devel libXmu-devel libfreeglut-devel

BuildRequires: eigen3

BuildRequires: libjpeg-devel libpng-devel libtheora-devel
BuildRequires: zlib-devel liblua5-devel libssl-devel
BuildRequires: libfmt-devel

BuildRequires: libgtk+2-devel libgtkglext-devel

%description
Celestia is a free real-time space simulation that
lets you experienceour universe in three dimensions.
Unlike most planetarium software, Celestia does not
confine you to the surface of the Earth. You can
travelthroughout the solar system, to any of over
100,000 stars, or even beyondthe galaxy.

%package common
Group: Education
Summary: A real-time visual space simulation (common part)
%description common
This is a common part of Celestia

Celestia is a free real-time space simulation that
lets you experienceour universe in three dimensions.
Unlike most planetarium software, Celestia does not
confine you to the surface of the Earth. You can
travelthroughout the solar system, to any of over
100,000 stars, or even beyondthe galaxy.

%package qt
Group: Education
Summary: A real-time visual space simulation (Qt5 frontend)
Requires: celestia-common = %EVR
Provides: celestia-ui = %version-%release
Provides: celestia = %version-%release
Obsoletes: celestia < %version-%release

%description qt
This is a Qt5 frontend to Celestia

Celestia is a free real-time space simulation that
lets you experienceour universe in three dimensions.
Unlike most planetarium software, Celestia does not
confine you to the surface of the Earth. You can
travelthroughout the solar system, to any of over
100,000 stars, or even beyondthe galaxy.

%package gtk
Group: Education
Summary: A real-time visual space simulation (GTK frontend)
Requires: celestia-common = %EVR
Provides: celestia-ui = %version-%release

%description gtk
This is a GTK frontend to Celestia

Celestia is a free real-time space simulation that
lets you experienceour universe in three dimensions.
Unlike most planetarium software, Celestia does not
confine you to the surface of the Earth. You can
travelthroughout the solar system, to any of over
100,000 stars, or even beyondthe galaxy.

%package glut
Group: Education
Summary: A real-time visual space simulation (GLUT frontend)
Requires: celestia-common = %EVR
Provides: celestia-ui = %version-%release

%description glut
This is a GLUT frontend to Celestia

Celestia is a free real-time space simulation that
lets you experienceour universe in three dimensions.
Unlike most planetarium software, Celestia does not
confine you to the surface of the Earth. You can
travelthroughout the solar system, to any of over
100,000 stars, or even beyondthe galaxy.

%prep
%setup
%patch -p2
%autoreconf

%build
# drop some warnings from build log
%add_optflags -Wno-int-in-bool-context
%configure \
    --with-gnu-ld \
    --without-arts \
    --with-lua \
    --with-glut \
    --with-gtk \
    #
%make_build

%install
%makeinstall_std
mkdir -p %buildroot%_desktopdir
install src/celestia/kde/data/%name.desktop %buildroot%_desktopdir/
install -D -m 644 src/celestia/gtk/data/%name.png %buildroot%_liconsdir/%name.png
install -D -m 644 src/celestia/gtk/data/%name.svg %buildroot%_iconsdir/hicolor/scalable/%name.svg

install -d %buildroot/etc/alternatives/packages.d
cat >%buildroot/etc/alternatives/packages.d/%name-qt <<__EOF__
%_bindir/celestia      %_bindir/celestia-qt 20
__EOF__

cat >%buildroot/etc/alternatives/packages.d/%name-gtk <<__EOF__
%_bindir/celestia      %_bindir/celestia-gtk 10
__EOF__

cat >%buildroot/etc/alternatives/packages.d/%name-glut <<__EOF__
%_bindir/celestia      %_bindir/celestia-glut 30
__EOF__

%find_lang %name

rm -fv %buildroot%_libdir/libcelmodel.a

%pre
[ ! -d %_datadir/apps/%name ] || rm -fr %_datadir/apps/%name

%files -f %name.lang common
#_datadir/apps/*
#_datadir/applnk/*
#_datadir/config/*
##%_bindir/makestardb
##%_bindir/makexindex
##%_bindir/startextdump
%_datadir/locale/*/*/celestia_constellations.mo
#_datadir/mimelnk/*
#_datadir/services/*
%_datadir/%name/
%_liconsdir/%name.png
%_iconsdir/hicolor/scalable/%name.svg
%_desktopdir/%name.desktop
%doc ChangeLog TRANSLATORS README NEWS

%files
%_bindir/celestia

#%files gtk
#%_bindir/celestia-gtk
#/etc/alternatives/packages.d/%name-gtk

#%files glut
#%_bindir/celestia-glut
#/etc/alternatives/packages.d/%name-glut

#%files qt
#%_bindir/celestia-qt
#/etc/alternatives/packages.d/%name-qt

%changelog
