%def_enable  ffmpeg
%def_enable  google_api_keys
%def_enable  samurai
%def_enable  gost

%ifndef build_parallel_jobs
%global build_parallel_jobs %__nprocs
%endif
%global max_jobs 96

%global llvm_version 21.1

%set_verify_elf_method rpath=relaxed textrel=relaxed lfs=relaxed lint=relaxed
%add_debuginfo_skiplist %_libdir/* %_bindir/*

%define _unpackaged_files_terminate_build 1

# Leave this alone, please.
%global target out/Release

# Set up Google API keys, see http://www.chromium.org/developers/how-tos/api-keys .
# Note: these are for ALT Linux use ONLY. For your own distribution,
# please get your own set of keys.
%define api_key               AIzaSyAIIWz7zaCwYcUSe3ZaRPviXjMjkBP4-xY
%define default_client_id     1018394967181.apps.googleusercontent.com
%define default_client_secret h_PrTP1ymJu83YTLyz-E25nP

Name:           chromium
Version:        142.0.7444.175
Release:        alt0.p11.1

Summary:        An open source web browser developed by Google
License:        BSD-3-Clause and LGPL-2.1+
Group:          Networking/WWW
Url:            https://www.chromium.org

Source0:        chromium.tar.zst

Source30:       master_preferences
Source31:       default_bookmarks.html
Source100:      chromium.sh
Source101:      chromium.desktop
Source102:      chromium.xml
Source200:      chromium.default

%if_enabled gost
# git clone --recurse-submodules https://github.com/deemru/chromium-gost.git
#   git checkout -b version commit_id && git submodule update --recursive
# cd ..; tar cvf chromium-gost.tar --exclude='.git*' chromium-gost
Source300:      chromium-gost.tar
Provides:       chromium-gost = %version
Obsoletes:      chromium-gost < %version
%endif

Provides:       chromium-browser = %version
Obsoletes:      chromium-browser < %version
Obsoletes:      chromium-stable <= %version

Provides:       webclient

Obsoletes:      chromium-password
Obsoletes:      chromium-kde
Obsoletes:      chromium-gnome
Obsoletes:      chromium-desktop-kde
Obsoletes:      chromium-desktop-gnome

ExclusiveArch: x86_64 aarch64

### Start Patches
Patch001: 0001-OPENSUSE-enables-reading-of-the-master-preference.patch
Patch002: 0002-ALT-Set-appropriate-desktop-file-name-for-default-br.patch
Patch003: 0003-DEBIAN-manpage-fixes.patch
Patch004: 0004-DEBIAN-ps-print.patch
Patch005: 0005-ALT-Use-rpath-link-and-absolute-rpath.patch
Patch006: 0006-ALT-allow-to-override-clang-through-env-variables.patch
Patch007: 0007-ALT-Hack-to-avoid-build-error-with-clang7.patch
Patch008: 0008-FEDORA-bootstrap-with-python3.patch
Patch009: 0009-ALT-use-system-zlib.patch
Patch010: 0010-gentoo-stylesheet.patch

Patch011: 0011-DEBIAN-allow-building-against-system-libraries-even-.patch
Patch012: 0012-DEBIAN-rust-no-alloc-shim.patch
Patch013: 0013-DEBIAN-use-system-opus-library-instead-of-embedded.patch
Patch014: 0014-DEBIAN-build-using-system-openjpeg.patch
Patch015: 0015-DEBIAN-use-system-jpeg-library.patch
Patch016: 0016-DEBIAN-disable-font-tests.patch
Patch017: 0017-DEBIAN-rust-sanitize.patch
Patch018: 0018-Use-yandex-search-as-default.patch
Patch019: 0019-DEBIAN-bindgen.patch

Patch021: 0021-FEDORA-System-brotli.patch
Patch022: 0022-ALT-block-error-from-google.patch
Patch023: 0023-Add-missing-headers.patch
Patch024: 0024-Disable-unsupported-compiler-flags.patch
Patch025: 0025-Fix-rust-clang-path.patch
Patch026: 0026-DEBIAN-remove-dependencies-on-third_party-catapult.patch

Patch031: 0031-FEDORA-disable-screen-ai-service.patch
Patch037: 0037-ALT-clang-path.patch
Patch038: 0038-ALT-std::exchange.patch

Patch041: 0041-DEBIAN-highway-include-path.patch
Patch042: 0042-DEBIAN-material-utils.patch
Patch043: 0043-DEBIAN-memory-allocator-dcheck-assert-fix.patch
Patch044: 0044-DEBIAN-av1-vaapi.patch
Patch045: 0045-DEBIAN-node-version-ck.patch
Patch046: 0046-DEBIAN-libcpp-headers.patch
Patch047: 0047-DEBIAN-chromium-142-iwyu-field-form-data.patch
Patch048: 0048-DEBIAN-clang19.patch

Patch051: 0051-OPENMANDRIVA-if-chromeos-can-do-it-so-can-linux.patch
Patch052: 0052-OPENMANDRIVA-enable-hw-video-encode.patch
Patch053: 0053-OPENMANDRIVA-drop-workarounds-for-ancient-mesa-bugs.patch
Patch054: 0054-OPENMANDRIVA-chromium-132-compile.patch

# trying to fix issues with YT playback:
Patch064: 0064-OPENSUSE-bring_back_and_disable_allowlist.patch
Patch065: 0065-DEBIAN-stdatomic.patch
Patch067: 0067-DEBIAN-gn-allowlist.patch
# for rust < 1.86:
Patch068: 0068-DEBIAN-adler1.patch

Patch070: 0070-FEDORA-type-mismatch-error.patch
Patch071: 0071-FEDORA-chromium-139-rust-FTBFS-suppress-warnings.patch

%if_enabled gost
Patch080: chromium-alt-check-themes.patch
%endif

### End Patches

BuildRequires(pre): rpm-macros-alternatives

BuildRequires: /proc
BuildRequires: /dev/shm

BuildRequires:  bison
BuildRequires:  brotli
BuildRequires:  bzlib-devel
BuildRequires:  chrpath
BuildRequires:  elfutils
BuildRequires:  flex
BuildRequires:  glibc-kernheaders
BuildRequires:  gperf
BuildRequires:  libcups-devel
BuildRequires:  libdouble-conversion-devel
#BuildRequires:  libstdc++-devel
#BuildRequires:  libstdc++-devel-static
BuildRequires:  libcxx-devel
BuildRequires:  libcxx-static
BuildRequires:  libcxxabi-devel
BuildRequires:  libcxxabi-static
BuildRequires:  llvm-libunwind-devel
BuildRequires:  llvm-libunwind-static
#BuildRequires:  libtiff-devel
BuildRequires:  ninja-build
BuildRequires:  node
BuildRequires:  nvidia-settings-devel
BuildRequires:  perl-Switch
BuildRequires:  pkg-config
BuildRequires:  usbids
BuildRequires:  xdg-utils
BuildRequires:  clang%{llvm_version}
BuildRequires:  clang%{llvm_version}-devel
BuildRequires:  llvm%{llvm_version}-devel
BuildRequires:  lld%{llvm_version}-devel
BuildRequires:  pkgconfig(absl_utility)
BuildRequires:  pkgconfig(alsa)
BuildRequires:  pkgconfig(atk)
BuildRequires:  pkgconfig(atk-bridge-2.0)
BuildRequires:  pkgconfig(atspi-2)
BuildRequires:  pkgconfig(cairo) >= 1.6
BuildRequires:  pkgconfig(dbus-1)
BuildRequires:  pkgconfig(dbus-glib-1)
BuildRequires:  pkgconfig(dri)
BuildRequires:  pkgconfig(epoxy)
BuildRequires:  pkgconfig(expat)
BuildRequires:  pkgconfig(flac)
BuildRequires:  pkgconfig(flatbuffers)
BuildRequires:  pkgconfig(fontconfig)
BuildRequires:  pkgconfig(freetype2)
BuildRequires:  pkgconfig(gbm)
BuildRequires:  pkgconfig(gconf-2.0)
BuildRequires:  pkgconfig(glib-2.0)
BuildRequires:  pkgconfig(gnome-keyring-1)
BuildRequires:  pkgconfig(gtk4)
BuildRequires:  pkgconfig(harfbuzz)
## BuildRequires:  pkgconfig(jsoncpp)
BuildRequires:  pkgconfig(krb5-gssapi)
BuildRequires:  pkgconfig(lcms2)
BuildRequires:  pkgconfig(libbrotlidec)
BuildRequires:  pkgconfig(libcurl)
BuildRequires:  pkgconfig(libdrm)
BuildRequires:  pkgconfig(libevdev)
## BuildRequires:  pkgconfig(libevent)
BuildRequires:  pkgconfig(libffi)
BuildRequires:  pkgconfig(libhwy)
BuildRequires:  pkgconfig(libjpeg)
BuildRequires:  pkgconfig(libopenjp2)
BuildRequires:  pkgconfig(libpci)
BuildRequires:  pkgconfig(libpipewire-0.3)
BuildRequires:  pkgconfig(libpng)
BuildRequires:  pkgconfig(libpulse)
BuildRequires:  pkgconfig(libsecret-1)
BuildRequires:  pkgconfig(libudev)
BuildRequires:  pkgconfig(libusb-1.0)
BuildRequires:  pkgconfig(libva)
BuildRequires:  pkgconfig(libwebp)
## BuildRequires:  pkgconfig(libwoff2dec)
BuildRequires:  pkgconfig(libxslt)
BuildRequires:  pkgconfig(libzstd)
BuildRequires:  pkgconfig(minizip)
BuildRequires:  pkgconfig(nspr)
BuildRequires:  pkgconfig(nss)
BuildRequires:  pkgconfig(openh264)
BuildRequires:  pkgconfig(re2)
## BuildRequires:  pkgconfig(snappy)
BuildRequires:  pkgconfig(uuid)
BuildRequires:  pkgconfig(x11)
BuildRequires:  pkgconfig(xcb-proto)
BuildRequires:  pkgconfig(xcomposite)
BuildRequires:  pkgconfig(xcursor)
BuildRequires:  pkgconfig(xdamage)
BuildRequires:  pkgconfig(xext)
BuildRequires:  pkgconfig(xfixes)
BuildRequires:  pkgconfig(xi)
BuildRequires:  pkgconfig(xkbcommon)
BuildRequires:  pkgconfig(xrandr)
BuildRequires:  pkgconfig(xrender)
BuildRequires:  pkgconfig(xscrnsaver)
BuildRequires:  pkgconfig(xshmfence)
BuildRequires:  pkgconfig(xt)
BuildRequires:  pkgconfig(xtst)
BuildRequires:  pkgconfig(zlib)
%if_enabled ffmpeg
BuildRequires:  pkgconfig(libavcodec)
BuildRequires:  pkgconfig(libavfilter)
BuildRequires:  pkgconfig(libavformat)
BuildRequires:  pkgconfig(libavutil)
BuildRequires:  pkgconfig(opus)
%endif
BuildRequires:  rust-bindgen

BuildRequires:  python3
BuildRequires:  python3(bs4)
BuildRequires:  python3(html5lib)
BuildRequires:  python3(markupsafe)
BuildRequires:  python3(ply)
BuildRequires:  python3(simplejson)

BuildRequires:  rust       >= 1.75.0-alt2
BuildRequires:  rust-cargo >= 1.75.0-alt2
%if_enabled gost
BuildRequires:  patchutils
%endif
%if_enabled samurai
BuildRequires:  samurai
%endif

# We do not build an internal version of libvulkan but we want to have it on the
# system.
#Requires: libvulkan1

Requires: libva
Requires: xdg-utils
Requires: icon-theme-hicolor

%description
Chromium is an open-source browser project that aims to build a safer,
faster, and more stable way for all Internet users to experience the web.

%prep
%setup -q -n chromium  %{?_enable_gost:-a300}
%autopatch -p1
# for rust after 1.86 revert adler2 patch:
%if "%(rpmquery --qf '%%{VERSION}' rust)" >= "1.86"
%patch068 -R -p1
%endif
%if_enabled gost
# Patches from chromium-gost
# Copy instruction from chromium-gost/build_linux/chromium-gost-prepare.sh
cp -f chromium-gost/extra/exit_0.sh chrome/installer/linux/common/repo.cron
cp -f chromium-gost/extra/exit_0.sh chrome/installer/linux/common/rpmrepo.cron

cp -f chromium-gost/extra/external_extensions.json chrome/browser/resources/default_apps/external_extensions.json
cp -f chromium-gost/extra/extensions/*.crx chrome/browser/resources/default_apps/

cp -f chromium-gost/src/gostssl.cpp third_party/boringssl/gostssl.cpp
cp -f chromium-gost/src/msspi/src/msspi.cpp third_party/boringssl/msspi.cpp
cp -f chromium-gost/src/msspi/src/msspi.h third_party/boringssl/msspi.h
cp -f chromium-gost/src/msspi/src/capix.hpp third_party/boringssl/capix.hpp

cp -f chromium-gost/src/msspi/third_party/cprocsp/include/CSP_SChannel.h third_party/boringssl/src/include/CSP_SChannel.h
cp -f chromium-gost/src/msspi/third_party/cprocsp/include/CSP_Sspi.h third_party/boringssl/src/include/CSP_Sspi.h
cp -f chromium-gost/src/msspi/third_party/cprocsp/include/CSP_WinBase.h third_party/boringssl/src/include/CSP_WinBase.h
cp -f chromium-gost/src/msspi/third_party/cprocsp/include/CSP_WinCrypt.h third_party/boringssl/src/include/CSP_WinCrypt.h
cp -f chromium-gost/src/msspi/third_party/cprocsp/include/CSP_WinDef.h third_party/boringssl/src/include/CSP_WinDef.h
cp -f chromium-gost/src/msspi/third_party/cprocsp/include/CSP_WinError.h third_party/boringssl/src/include/CSP_WinError.h
cp -f chromium-gost/src/msspi/third_party/cprocsp/include/WinCryptEx.h third_party/boringssl/src/include/WinCryptEx.h
cp -f chromium-gost/src/msspi/third_party/cprocsp/include/common.h third_party/boringssl/src/include/common.h

cat > chromium-gost-excluded << CG_EXCLUDED
chrome/app/theme/chromium/BRANDING
chrome/browser/shell_integration_linux.cc
chrome/common/channel_info_posix.cc
chrome/installer/linux/common/chromium-browser/chromium-browser.info
components/search_engines/prepopulated_engines.json
components/search_engines/search_terms_data.cc
content/common/user_agent.cc
CG_EXCLUDED
sed -E 's@^((diff --git|[-+]{3}) a)/(.*)@\1/third_party/boringssl/src/\3@' < chromium-gost/patch/boringssl.patch | patch -p1
filterdiff -p1 -X chromium-gost-excluded < chromium-gost/patch/chromium.patch | sed -E 's@^((diff --git|[-+]{3}) a)/(.*)@\1/third_party/boringssl/src/\3@; s@return "chromium-browser@return "chromium@' | patch -p1
## c-g patch incompatibility introduced in 94.0.4606.71
sed -i '1i\
#if __has_attribute(no_destroy)\
#  define _LIBCPP_NO_DESTROY __attribute__((__no_destroy__))\
#else\
#  define _LIBCPP_NO_DESTROY\
#endif
' net/socket/ssl_client_socket_impl.cc
%endif
sed -i \
        -e 's/"-ffile-compilation-dir=."//g' \
        -e 's/"-no-canonical-prefixes"//g' \
        -e 's/"-no-opaque-pointers",//g' \
        build/config/compiler/BUILD.gn
sed -i -e 's/'-Wundef',//' tools/gn/build/gen.py
subst 's/-static-libstdc++/--stdlib=libc++/' `grep -Rl 'static-libstdc++' *`

mkdir -p third_party/node/linux/node-linux-x64/bin
ln -s %_bindir/node third_party/node/linux/node-linux-x64/bin/node

mkdir -p buildtools/third_party/eu-strip/bin
ln -sf %_bindir/eu-strip buildtools/third_party/eu-strip/bin/eu-strip

mkdir -p third_party/rust-toolchain/bin
ln -sf %_bindir/bindgen third_party/rust-toolchain/bin/bindgen

rm -f -- third_party/depot_tools/ninja
ln -s %_bindir/ninja third_party/depot_tools/ninja
ln -s %_bindir/python3 third_party/depot_tools/python

%build
export ALTWRAP_LLVM_VERSION="%llvm_version"
export CC="clang"
export CXX="clang++"
export AR="llvm-ar"
export NM="llvm-nm"
export READELF="llvm-readelf"
export RANLIB="llvm-ranlib"
export LLVM_PREFIX=`llvm-config --prefix`
export LLVM_LIBDIR=`llvm-config --libdir`
export CLANG_MAJVER=`echo %llvm_version | cut -d. -f1`
export CLANG_LIBDIR="$LLVM_LIBDIR/clang/$CLANG_MAJVER/lib"

bits=$(getconf LONG_BIT)

export PATH="$PWD/third_party/depot_tools:$PATH"
export CHROMIUM_RPATH="%_libdir/%name"

FLAGS=
FLAGS+=' -fno-delete-null-pointer-checks'
FLAGS+=' -DUSE_SYSTEM_MINIZIP'
#FLAGS+=' -stdlib=libc++'
# FLAGS+=' -I/usr/include/c++/v1 -I/usr/include/c++/14 -I/usr/include/c++/14/x86_64-alt-linux'
FLAGS+=' -I/usr/include/c++/v1'
FLAGS+=' -Wno-deprecated-declarations'
FLAGS+=' -Wno-implicit-fallthrough -Wno-nontrivial-memcall -Wno-shadow'
FLAGS+=' -Wno-macro-redefined'
FLAGS+=' -Wno-error -Wno-undef'

export CFLAGS="$FLAGS"
export CXXFLAGS="$FLAGS"
export LDFLAGS="$LDFLAGS -stdlib=libc++ -L/usr/lib64 -lc++ -lc++abi"

# Debian:
# enable_vr=false

gn_arg=()
gn_arg+=( custom_toolchain=\"//build/toolchain/linux/unbundle:default\" )
gn_arg+=( host_toolchain=\"//build/toolchain/linux/unbundle:default\" )
gn_arg+=( is_official_build=true )
gn_arg+=( use_custom_libcxx=false )
gn_arg+=( use_sysroot=false )
gn_arg+=( use_gio=true )
gn_arg+=( use_glib=true )
gn_arg+=( use_libpci=true )
gn_arg+=( use_pulseaudio=true )
gn_arg+=( use_cups=true )
gn_arg+=( use_kerberos=true )
gn_arg+=( use_vaapi=true )
gn_arg+=( use_system_freetype=true )
gn_arg+=( use_system_harfbuzz=true )
gn_arg+=( use_system_lcms2=true )
gn_arg+=( use_system_libffi=true )
gn_arg+=( use_system_libdrm=false )
gn_arg+=( use_system_libjpeg=true )
gn_arg+=( use_system_libopenjpeg2=true )
gn_arg+=( use_libjpeg_turbo=true )
gn_arg+=( use_system_libpng=true )
gn_arg+=( use_system_minigbm=true )
gn_arg+=( use_system_zlib=true )
gn_arg+=( use_bundled_weston=false )
gn_arg+=( use_xkbcommon=true )
gn_arg+=( use_icf=false )
gn_arg+=( enable_linux_installer=false )
gn_arg+=( optimize_webui=false )
gn_arg+=( link_pulseaudio=true )
gn_arg+=( enable_hangout_services_extension=true )
gn_arg+=( treat_warnings_as_errors=false )
gn_arg+=( clang_warning_suppression_file=\"\" )
gn_arg+=( fatal_linker_warnings=false )
gn_arg+=( system_libdir=\"%_lib\" )
gn_arg+=( enable_nocompile_tests=false )

# toolkit
gn_arg+=( use_qt5=false )
gn_arg+=( use_qt6=false )
gn_arg+=( use_gtk=true )
gn_arg+=( gtk_version=4 )

# ozone
gn_arg+=( use_ozone=true )
gn_arg+=( ozone_platform=\"x11\" )
gn_arg+=( ozone_platform_x11=true )
gn_arg+=( ozone_platform_wayland=true )
#gn_arg+=( angle_enable_gl=true )
#gn_arg+=( angle_enable_vulkan=true )
gn_arg+=( angle_has_histograms=false )
gn_arg+=( angle_build_tests=false )
gn_arg+=( build_angle_perftests=false )

# ffmpeg
gn_arg+=( ffmpeg_branding=\"Chrome\" )
gn_arg+=( proprietary_codecs=true )

# Remove debug
gn_arg+=( is_debug=false )
gn_arg+=( enable_iterator_debugging=false )
gn_arg+=( dcheck_always_on=false )
gn_arg+=( dcheck_is_configurable=false )
gn_arg+=( symbol_level=0 )
gn_arg+=( blink_symbol_level=0 )
gn_arg+=( v8_symbol_level=0 )
gn_arg+=( v8_enable_backtrace=true )
gn_arg+=( disable_fieldtrial_testing_config=true )

gn_arg+=( enable_enterprise_companion=false )
gn_arg+=( is_component_ffmpeg=false )
gn_arg+=( is_component_build=false )
gn_arg+=( enable_widevine=true )

gn_arg+=( rtc_use_pipewire=true )
gn_arg+=( rtc_link_pipewire=true )

gn_arg+=( clang_base_path=\"$LLVM_PREFIX\" )
gn_arg+=( is_clang=true )
gn_arg+=( clang_use_chrome_plugins=false )
gn_arg+=( use_lld=true )
%ifarch x86_64
    gn_arg+=( use_thin_lto=true )
    gn_arg+=( thin_lto_enable_optimizations=true )
%else
    gn_arg+=( use_thin_lto=false )
    gn_arg+=( thin_lto_enable_optimizations=false )
%endif
gn_arg+=( is_cfi=false )
gn_arg+=( use_cfi_icall=false )
gn_arg+=( chrome_pgo_phase=0 )

# use system rust
export RUSTC_BOOTSTRAP=1
gn_arg+=( rust_sysroot_absolute=\"$(rustc --print sysroot)\" )
gn_arg+=( rustc_version=\"$(rustc --version)\" )

%ifnarch x86_64
gn_arg+=( icu_use_data_file=false )
%else
gn_arg+=( icu_use_data_file=true )
%endif

%ifarch x86_64 aarch64
gn_arg+=( angle_enable_vulkan=true )
gn_arg+=( enable_vulkan=true )
%else
gn_arg+=( enable_vulkan=false )
%endif
gn_arg+=( use_system_libtiff=false )
gn_arg+=( safe_browsing_use_unrar=false )
gn_arg+=( build_dawn_tests=false )

%if_enabled google_api_keys
### From 2013 until early 2021, Google permitted distribution builds of
### Chromium to access Google APIs that added significant features to
### Chromium including, but not limited to, Sync and geolocation.
### As of March 15, 2021, any Chromium builds which pass client_id and/or
### client_secret during build will prevent end-users from signing into their
### Google account.
###
### I have removed the calls to "google_default_client_id"
### and "google_default_client_secret" to comply with their changes.
###
### We can still use the api key though. For now.
gn_arg+=( google_api_key=\"%api_key\" )

#gn_arg+=( google_default_client_id=\"%default_client_id\" )
#gn_arg+=( google_default_client_secret=\"%default_client_secret\" )
%endif

# Clang path
gn_arg+=( clang_base_path=\"/usr/lib/llvm-%llvm_version\" )
# Includedir /usr/lib/llvm-18.1/lib64/clang/18/include

# Remove bundled libraries for which we will use the system copies.
.rpm/scripts/unbundle

tools/gn/bootstrap/bootstrap.py --gn-gen-args="${gn_arg[*]}" --build-path=%target
%target/gn --script-executable=%__python3 gen --args="${gn_arg[*]}" %target

%if_enabled samurai
export NINJA=samu
%else
export NINJA=ninja
if [ -r %target/toolchain.ninja ]; then
	# We never perform incremental builds,
	# so we do not need to maintain extensive deps logs,
	# nor stat the outputs too many times.
	# TODO: Prevent gn from generating deps=1 in the first place.
	subst '
		/^[[:space:]]\+deps[[:space:]]=/d;
		/^[[:space:]]\+depfile[[:space:]]=/d;
	' %target/toolchain.ninja
fi
%endif

n=%build_parallel_jobs
[ "$n" -lt %max_jobs ] || n=%max_jobs

for name in chrome chrome_sandbox chromedriver policy_templates; do
	export NINJA_STATUS="[$name %%f/%%t] "
	/usr/bin/time $NINJA -j "$n" -C %target $name
done


%install
mkdir -p -- \
	%buildroot/%_bindir \
	%buildroot/%_man1dir \
	%buildroot/%_libdir/%name \
	%buildroot/%_sysconfdir/%name \
#
install -m 755 %SOURCE100 %buildroot%_bindir/%name
install -m 644 %SOURCE200 %buildroot%_sysconfdir/%name/default

# add directories for policy management
mkdir -p %buildroot%_sysconfdir/%name/policies/managed
mkdir -p %buildroot%_sysconfdir/%name/policies/recommended

# compatibility symlink
ln -s %name %buildroot/%_bindir/chromium-browser

# manpage
.rpm/scripts/make-manpage.sh > %buildroot/%_man1dir/%name.1
ln -s %name.1  %buildroot/%_man1dir/chrome.1

pushd %target
cp -a chrome           %buildroot%_libdir/%name/%name
cp -a chrome_sandbox   %buildroot%_libdir/%name/chrome-sandbox
cp -a chrome_crashpad_handler %buildroot%_libdir/%name/chrome_crashpad_handler

for chromedriver in chromedriver chromedriver.unstripped; do
	[ ! -x $chromedriver ] || break
done

cp -a $chromedriver %buildroot%_libdir/%name/chromedriver
strip %buildroot%_libdir/%name/chromedriver

ln -s -- %_libdir/%name/chromedriver %buildroot/%_bindir/chromedriver

for f in *.bin *.so* *.pak swiftshader locales icudtl.dat MEIPreload vk_swiftshader_icd.json; do
	[ ! -e "$f" ] ||
		cp -at %buildroot%_libdir/%name -- "$f"
done
popd

# Remove garbage
find %buildroot%_libdir/%name -name '*.TOC' -delete
find %buildroot%_libdir/%name/locales -name '*.pak.info' -delete

# Icons
for size in 24 48 64 128 256; do
	install -Dm644 "chrome/app/theme/chromium/product_logo_$size.png" \
		"%buildroot/%_iconsdir/hicolor/${size}x${size}/apps/%name.png"
done
for size in 16 32; do
	install -Dm644 "chrome/app/theme/default_100_percent/chromium/product_logo_$size.png" \
		"%buildroot/%_iconsdir/hicolor/${size}x${size}/apps/%name.png"
done

# Desktop file
install -Dm0644 %SOURCE101 %buildroot/%_desktopdir/%name.desktop

mkdir -p -- %buildroot%_datadir/gnome-control-center/default-apps/
cp -a %SOURCE102 %buildroot%_datadir/gnome-control-center/default-apps/%name.xml

# link to browser plugin path.  Plugin patch doesn't work. Why?
mkdir -p -- %buildroot%_libdir/browser-plugins
ln -s -- %_libdir/browser-plugins %buildroot%_libdir/%name/plugins

# Install the master_preferences file
mkdir -p -- %buildroot%_sysconfdir/%name
install -m 0644 %SOURCE30 %buildroot%_sysconfdir/%name
install -m 0644 %SOURCE31 %buildroot%_sysconfdir/%name

# Set alternative to xbrowser
mkdir -p -- %buildroot%_altdir
cat >%buildroot%_altdir/%name <<EOF
%_bindir/xbrowser	%_bindir/%name	50
%_bindir/x-www-browser	%_bindir/%name	50
EOF

(set +x;
	find %buildroot/%_libdir/%name -type f |
	while read f; do
		t="$(readlink -ev "$f")"

		file "$t" | grep -Fqs ELF || continue

		# Strip Chromium executables to disable debuginfo generation (became too huge)
		#strip -d "$t" ||:

		# Add real RPATH
		chrpath -r '%_libdir/%name' "$t" ||:
	done
)


%files
%doc AUTHORS LICENSE
%dir %_datadir/gnome-control-center/default-apps
%dir %_sysconfdir/%name
%dir %_sysconfdir/%name/policies
%dir %_sysconfdir/%name/policies/managed
%dir %_sysconfdir/%name/policies/recommended
%config %_sysconfdir/%name/*
%attr(4711,root,root) %_libdir/%name/chrome-sandbox
%_libdir/%name
%_bindir/*
%_man1dir/*
%_desktopdir/%name.desktop
%_datadir/gnome-control-center/default-apps/*.xml
%_iconsdir/hicolor/*/apps/*.png
%_altdir/%name

%changelog
