# Unpackaged files in buildroot should terminate build
%define _unpackaged_files_terminate_build 1

%define ver_major 6.4
%define api_ver 3.0

Name: cinnamon-menus
Version: %ver_major.0
Release: alt1

Summary: Cinnamon desktop menu
License: GPL-2.0-or-later
Group: Graphical desktop/GNOME
Url: https://github.com/linuxmint/cinnamon-menus

Source: %name-%version.tar
Patch: %name-%version-%release.patch

BuildPreReq: rpm-build-gnome rpm-build-xdg

# From configure.in
BuildPreReq: intltool >= 0.35 gnome-common
BuildPreReq: libgio-devel >= 2.29.15
BuildRequires: gobject-introspection-devel
BuildRequires: meson

%description
cinnamon-menus contains the libcinnamon-menu library and the
layout configuration files for the Cinnamon menu.

%package -n lib%name
Summary: Desktop Menu Library for Cinnamon
License: LGPLv2+
Group: System/Libraries
Provides: cinnamon-menus-common = %version-%release

%description -n lib%name
This package provides Desktop Menu Library for Cinnamon.

%package -n lib%name-devel
Summary: Development files for Cinnamon Desktop Menu Library
License: LGPLv2+
Group: Development/C
Requires: lib%name = %version-%release

%description -n lib%name-devel
This package provides files required to develop programs that use
Desktop Menu Library.

%package -n lib%name-devel-examples
Summary: Development utilities and examples for Cinnamon Desktop Menu Library
License: LGPLv2+
Group: Development/Python
BuildArch: noarch
Requires: lib%name = %version-%release

%description -n lib%name-devel-examples
This package provides some examples that use Desktop Menu Library.

%package -n lib%name-gir
Summary: GObject introspection data for the Cinnamon Desktop Menu Library
Group: System/Libraries
Requires: lib%name = %version-%release

%description -n lib%name-gir
GObject introspection data for the Cinnamon Desktop Menu Library

%package -n lib%name-gir-devel
Summary: GObject introspection devel data for the Cinnamon Desktop Menu Library
Group: System/Libraries
BuildArch: noarch
Requires: lib%name-gir = %version-%release

%description -n lib%name-gir-devel
GObject introspection devel data for the Cinnamon Desktop Menu Library

%add_findreq_skiplist %_xdgmenusdir/*

%prep
%setup
%patch -p1

%build
%meson
%meson_build

%install
%meson_install

%find_lang %name-%api_ver

%files -n lib%name -f %name-%api_ver.lang
%_libdir/*.so.*
%doc AUTHORS NEWS README

%files -n lib%name-devel
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/*

%files -n lib%name-gir
%_typelibdir/*

%files -n lib%name-gir-devel
%_girdir/*


%changelog
