# Unpackaged files in buildroot should terminate build
%define _unpackaged_files_terminate_build 1

%define ver_major 6.4
%define api_ver 3.0
%def_disable static
%def_enable smartcard
%def_enable systemd

%define _libexecdir %_prefix/libexec

Name: cinnamon-settings-daemon
Version: %ver_major.2
Release: alt1

Summary: A program that manages general Cinnamon settings
License: GPL-2.0-or-later
Group: Graphical desktop/GNOME
Url: https://github.com/linuxmint/cinnamon-settings-daemon

Source: %name-%version.tar
Patch: %name-%version-%release.patch

# From configure.ac
%define glib2_ver 2.29.14
%define gtk_ver 3.3.18
%define gio_ver 2.29.14
%define cinnamon_desktop_ver 2.6.3
%define notify_ver 0.7.3
%define pulse_ver 0.9.15
%define csds_ver 3.3.0
%define colord_ver 0.1.9
%define dconf_ver 0.8
%define upower_ver 0.9.1
%define systemd_ver 40
%define desk_schemas_ver 3.6
%define gnomekbd_ver 2.91.1
%define xklavier_ver 5.0
%define ibus_ver 1.4.2

Requires: dconf >= %dconf_ver
Requires: colord >= %colord_ver
Requires: %name-translations

# From configure.ac
BuildPreReq: glib2-devel >= %glib2_ver
BuildPreReq: libgtk+3-devel >= %gtk_ver
BuildPreReq: libgio-devel >= %gio_ver
BuildPreReq: libcinnamon-desktop-devel >= %cinnamon_desktop_ver
BuildPreReq: libnotify-devel >= %notify_ver
BuildPreReq: gsettings-desktop-schemas-devel >= %desk_schemas_ver
BuildPreReq: libpulseaudio-devel >= %pulse_ver libcanberra-gtk3-devel
BuildRequires: libdbus-devel libdbus-glib-devel libpolkit-devel
%{?_enable_smartcard:BuildRequires: libnss-devel}
%{?_enable_systemd:BuildRequires: systemd-devel >= %systemd_ver libsystemd-login-devel}
BuildRequires: libxkbfile-devel
BuildRequires: rpm-build-gnome docbook-style-xsl xsltproc
BuildRequires: gcc-c++ libcups-devel libgudev-devel libXi-devel libXext-devel libXfixes-devel libXtst-devel
BuildRequires: libXrandr-devel xorg-inputproto-devel libICE-devel libSM-devel
BuildRequires: libupower-devel >= %upower_ver
BuildRequires: libcolord-devel >= %colord_ver liblcms2-devel
BuildRequires: libgnomekbd-devel >= %gnomekbd_ver
BuildRequires: libxklavier-devel >= %xklavier_ver
BuildRequires: libxklavier-devel >= %xklavier_ver
BuildRequires: libibus-devel >= %ibus_ver
BuildRequires: libcom_err-devel
BuildRequires: libkrb5-devel
BuildRequires: librsvg-devel
BuildRequires: libwacom-devel
BuildRequires: meson
BuildRequires: cmake

%description
Cinnamon Settings Daemon is a program that organizes access to general Cinnamon
settings. Other Cinnamon programs may interact with cinnamon-settings-daemon to
obtain or change some settings. One of the most prominent examples of a c-s-d
client is Cinnamon Control Center.

%package devel
Summary: Cinnamon Settings Daemon development files
Group: Development/GNOME and GTK+
Requires: %name = %version-%release

%description devel
The %name-devel package contains libraries and header files for
developing applications that use %name.

%prep
%setup -q
%patch0 -p1

%build
%meson
%meson_build

%install
%meson_install

%files
%doc AUTHORS NEWS
%dir %_libdir/%name-%api_ver
%_bindir/csd-*
%_libdir/%name-%api_ver/*.so
%_libdir/%name/csd-*
%_libexecdir/csd-*
%_datadir/%name
%_iconsdir/hicolor/*/*/*.png
%_iconsdir/hicolor/*/*/*.svg
%config %_datadir/glib-2.0/schemas/*
%_datadir/polkit-1/actions/org.cinnamon.settings-daemon.plugins.power.policy
%_datadir/polkit-1/actions/org.cinnamon.settingsdaemon.datetimemechanism.policy
%_datadir/polkit-1/actions/org.cinnamon.settings-daemon.plugins.wacom.policy
%_datadir/dbus-1/system-services/org.cinnamon.SettingsDaemon.DateTimeMechanism.service
%_datadir/dbus-1/system.d/org.cinnamon.SettingsDaemon.DateTimeMechanism.conf
%_sysconfdir/xdg/autostart/*.desktop
%_datadir/applications/*.desktop

%exclude %_datadir/%name-%api_ver/input-device-example.sh

%files devel
%_includedir/*
%_pkgconfigdir/*

%changelog
