%def_enable check
%define _libexecdir /usr/libexec

Name:    cloud-init
Version: 25.1.4
Release: alt1

Summary: Cloud instance init scripts
Group:   System/Configuration/Boot and Init
License: GPLv3
Url:     http://launchpad.net/cloud-init
Vcs:     https://github.com/canonical/cloud-init

Source0: %name-%version.tar

Source1: cloud-init-alt.cfg
Source2: cloud-init-tmpfiles.conf
Source3: ds-identify.cfg

Source11: cloud-config
Source12: cloud-final
Source13: cloud-init
Source14: cloud-init-local

# Network configs
Source31: 01_netplan.cfg
Source32: 01_etcnet.cfg
Source33: 01_network-manager.cfg

# Other configs
Source41: 90_datasource-list.cfg

Patch1: %name-%version-%release.patch
Patch2: use_python3_in_uncloud-init.patch

%add_findreq_skiplist %_systemdgeneratordir/cloud-init-generator

BuildArch: noarch

%filter_from_requires /^open-vm-tools/d
%filter_from_requires /^systemd/d
%filter_from_requires /^\/init/d
%filter_from_requires s/requests.packages.urllib3.connectionpool/urllib3.connectionpool/

BuildRequires(pre): rpm-build-python3
BuildRequires(pre): rpm-macros-systemd >= 5
#BuildRequires(pre): rpm-build-pyproject
BuildRequires: python3-dev python3-module-setuptools python3-module-wheel
BuildRequires: python3-module-yaml python3-module-oauthlib
BuildRequires: libsystemd-devel libudev-devel
BuildRequires: python3-module-serial iproute2
BuildRequires: util-linux net-tools python3-module-jinja2
BuildRequires: python3-module-contextlib2 python3-module-prettytable
BuildRequires: python3-module-requests
BuildRequires: pkgconfig(systemd) pkgconfig(udev)
%if_enabled check
BuildRequires: /proc
BuildRequires: python3-module-jsonpatch
BuildRequires: python3-module-configobj python3-module-mock
BuildRequires: python3-module-oauthlib python3-module-pytest
BuildRequires: python3-module-pytest-mock
BuildRequires: python3(jsonschema) python3(responses)
BuildRequires: python3(passlib)
BuildRequires: shadow-utils passwd
%endif

Requires: sudo
Requires: e2fsprogs
Requires: cloud-utils-growpart
Requires: procps
Requires: iproute net-tools
Requires: shadow-utils
Requires: shadow-change
Requires: shadow-convert
Requires: /bin/run-parts
Requires: dhcp-client
Requires: netcat-tls
# add not autoreq'ed
%py3_requires Cheetah
%py3_requires jinja2

# use urllib3 for requests.packages.urllib3
%py3_requires urllib3
%filter_from_requires /python3(requests.packages.urllib3.connection)/d
%filter_from_requires /python3(requests.packages.urllib3.poolmanager)/d

%description
Cloud-init is a set of init scripts for cloud instances.  Cloud instances
need special scripts to run during initialization to retrieve and install
ssh keys and to let the user run various scripts.

%package config-netplan
Summary: Cloud config option use netplan network render
Group:   System/Configuration/Boot and Init
License: GPLv3

Requires: cloud-init >= 21.3
Requires: netplan
Conflicts: cloud-init-config-etcnet cloud-init-config-network-manager

%description config-netplan
%summary.

%package config-etcnet
Summary: Cloud config option use etcnet network render
Group:   System/Configuration/Boot and Init
License: GPLv3

Requires: cloud-init >= 21.3
Requires: etcnet
Conflicts: cloud-init-config-netplan cloud-init-config-network-manager

%description config-etcnet
%summary.

%package config-network-manager
Summary: Cloud config option use NetworkManager network render
Group:   System/Configuration/Boot and Init
License: GPLv3

Requires: cloud-init >= 22.2.2
Requires: NetworkManager
Conflicts: cloud-init-config-etcnet cloud-init-config-netplan

%description config-network-manager
%summary.

%prep
%setup
%patch1 -p1
%patch2 -p1

%build
%pyproject_build

%install
%python3_install  --distro altlinux --init-system systemd
#%%pyproject_install -- --init-system systemd --distro altlinux

# Generate cloud-config file
#python3 tools/render-template --variant altlinux > %buildroot%_sysconfdir/cloud/cloud.cfg.test
#install -pD -m644 %SOURCE1 %buildroot%_sysconfdir/cloud/cloud.cfg

install -pD -m644 %SOURCE2 %buildroot%_tmpfilesdir/cloud-init.conf
install -pD -m644 %SOURCE3 %buildroot%_sysconfdir/cloud/

install -pD -m755 %SOURCE11 %buildroot%_initdir/cloud-config
install -pD -m755 %SOURCE12 %buildroot%_initdir/cloud-final
install -pD -m755 %SOURCE13 %buildroot%_initdir/cloud-init
install -pD -m755 %SOURCE14 %buildroot%_initdir/cloud-init-local

# Install network configs
install -pD -m644 %SOURCE31 %buildroot%_sysconfdir/cloud/cloud.cfg.d/
install -pD -m644 %SOURCE32 %buildroot%_sysconfdir/cloud/cloud.cfg.d/
install -pD -m644 %SOURCE33 %buildroot%_sysconfdir/cloud/cloud.cfg.d/

# Install other configs
install -pD -m644 %SOURCE41 %buildroot%_sysconfdir/cloud/cloud.cfg.d/

mkdir -p %buildroot%_sharedstatedir/cloud

# Remove non-ALTLinux templates
rm -f %buildroot%_sysconfdir/cloud/templates/*almalinux*
rm -f %buildroot%_sysconfdir/cloud/templates/*alpine*
rm -f %buildroot%_sysconfdir/cloud/templates/*arch*
rm -f %buildroot%_sysconfdir/cloud/templates/*azurelinux*
rm -f %buildroot%_sysconfdir/cloud/templates/*centos*
rm -f %buildroot%_sysconfdir/cloud/templates/*cloudlinux*
rm -f %buildroot%_sysconfdir/cloud/templates/*fedora*
rm -f %buildroot%_sysconfdir/cloud/templates/*opensuse*
rm -f %buildroot%_sysconfdir/cloud/templates/*photon*
rm -f %buildroot%_sysconfdir/cloud/templates/*rhel*
rm -f %buildroot%_sysconfdir/cloud/templates/*sle*
rm -f %buildroot%_sysconfdir/cloud/templates/*gentoo*
rm -f %buildroot%_sysconfdir/cloud/templates/*mariner*
rm -f %buildroot%_sysconfdir/cloud/templates/*debian*
rm -f %buildroot%_sysconfdir/cloud/templates/*freebsd*
rm -f %buildroot%_sysconfdir/cloud/templates/*openbsd*
rm -f %buildroot%_sysconfdir/cloud/templates/*redhat*
rm -f %buildroot%_sysconfdir/cloud/templates/*suse*
rm -f %buildroot%_sysconfdir/cloud/templates/*ubuntu*

%check
export PATH="$PATH:/usr/sbin"
export PYTHONPATH=%buildroot%python3_sitelibdir
python3 -m pytest -v tests/unittests \
  --ignore tests/unittests/config/test_apt_configure_sources_list_v1.py \
  --ignore tests/unittests/config/test_apt_configure_sources_list_v3.py

%post
%post_systemd cloud-init-main.service cloud-init-local.service cloud-init-network.service cloud-config.service cloud-final.service

%preun
%preun_systemd cloud-init-main.service cloud-init-local.service cloud-init-network.service cloud-config.service cloud-final.service
%preun_systemd cloud-init.service

%triggerin -- %name < 24.4.1
# Update systemd units to version 24.4.1
if systemctl is-enabled cloud-init.service >/dev/null 2>&1; then
        systemctl disable --now cloud-init.service >/dev/null 2>&1 ||:
fi
if systemctl is-enabled cloud-init-local.service >/dev/null 2>&1; then
	systemctl stop cloud-init-local.service cloud-init-network.service cloud-config.service cloud-final.service >/dev/null 2>&1 ||:
	systemctl enable --now cloud-init-main.service >/dev/null 2>&1 ||:
	systemctl start cloud-init-local.service cloud-init-network.service cloud-config.service cloud-final.service >/dev/null 2>&1 ||:
fi

%files config-netplan
%config            %_sysconfdir/cloud/cloud.cfg.d/01_netplan.cfg

%files config-etcnet
%config            %_sysconfdir/cloud/cloud.cfg.d/01_etcnet.cfg

%files config-network-manager
%config            %_sysconfdir/cloud/cloud.cfg.d/01_network-manager.cfg

%files
%doc ChangeLog
%dir               %_sysconfdir/cloud
%dir               %_sysconfdir/cloud/clean.d
%config(noreplace) %_sysconfdir/cloud/*.cfg
%dir               %_sysconfdir/cloud/cloud.cfg.d
%config(noreplace) %_sysconfdir/cloud/cloud.cfg.d/*.cfg
%exclude           %_sysconfdir/cloud/cloud.cfg.d/01_netplan.cfg
%exclude           %_sysconfdir/cloud/cloud.cfg.d/01_etcnet.cfg
%exclude           %_sysconfdir/cloud/cloud.cfg.d/01_network-manager.cfg
%doc               %_sysconfdir/cloud/cloud.cfg.d/README
%dir               %_sysconfdir/cloud/templates
%config(noreplace) %_sysconfdir/cloud/templates/*
%config %_unitdir/sshd-keygen@.service.d/disable-sshd-keygen-if-cloud-init-active.conf
%_datadir/bash-completion/completions/%name
%_udevrulesdir/66-azure-ephemeral.rules
%_initdir/*
%_unitdir/*
%_tmpfilesdir/*
%_systemdgeneratordir/cloud-init-generator
%python3_sitelibdir/*
%_libexecdir/%name
%_bindir/cloud-init*
%_bindir/cloud-id
%doc %_datadir/doc/%name
%dir %_sharedstatedir/cloud

%changelog
