%if_feature php83 8.3.0
%def_with php83
%define defphp php8.3
%endif

%if_feature php80 8.0.0
%def_with php80
%define defphp php8.0
%endif

%if_feature php81 8.1.0
%def_with php81
%define defphp php8.1
%endif

%if_feature php82 8.2.0
%def_with php82
%define defphp php8.2
%endif

%if_feature php7 7.4.3
%def_with php7
%define defphp php7
%endif


# Note: /usr/bin/compose still use php command

Name: composer
Version: 2.7.2
Release: alt1

Summary: Composer helps you declare, manage and install dependencies of PHP projects, ensuring you have the right stack everywhere

License: MIT
Group: System/Configuration/Packaging
Url: https://getcomposer.org/

Packager: Vitaly Lipatov <lav@altlinux.ru>

# Source-url: https://github.com/composer/composer/archive/%version.tar.gz
Source: %name-%version.tar
Source1: composer.sh
Source2: composer.sysconfig
Source3: compile
Source4: README.ALT

Source10: %name-production-%version.tar

Patch1: composer-compiler.patch

BuildArch: noarch

BuildRequires(pre): rpm-macros-features >= 0.8
BuildRequires: %defphp >= 7.2.5

Requires: %_bindir/%defphp
Requires: %defphp >= 7.2.5
Requires: %defphp-openssl

%description
Composer helps you declare, manage and install dependencies of PHP projects,
ensuring you have the right stack everywhere.

%prep
%setup -a 10
%patch1 -p2
install %SOURCE3 -D ./compile
cp %SOURCE4 .
%__subst "s|src/Composer/Composer.php|disable-date-changing|" src/Composer/Composer.php
# disable selfupdate
%__subst "s|.*SelfUpdateCommand.*||" src/Composer/Console/Application.php

%build
# unused date
# Note! stat -c%%y output is incompatible with date in python!
export RELDATE="$(stat -c '%%y' composer.json | sed -e 's|\.[0-9]* | |')"
#build composer.phar
%defphp -d phar.readonly=off -d date.timezone='Europe/Moscow' ./compile %version "$RELDATE"

%install
install -m 0755 -D composer.phar %buildroot/%_datadir/composer.phar
install -m 0755 -D %SOURCE1 %buildroot/%_bindir/%name
install -m 0644 -D %SOURCE2 %buildroot%_sysconfdir/sysconfig/%name

%files
%doc README.ALT
%attr(755,root,root) %_bindir/%name
%attr(755,root,root) %_datadir/%name.phar
%config(noreplace) %_sysconfdir/sysconfig/%name

%changelog
