Name: confuse
Version: 3.3
Release: alt1

Summary: A library for parsing configuration files
License: ISC
Group: System/Libraries
Url: http://www.nongnu.org/confuse

Source0: http://bzero.se/confuse/%name-%version.tar.gz

Packager: Ilya Mashkin <oddity@altlinux.ru>

BuildPreReq: rpm-build-licenses
BuildPreReq: check cvs flex gcc-c++

%description
libConfuse is a configuration file parser library, licensed under the
terms of the LGPL, and written in C. It supports sections and (lists of)
values (strings, integers, floats, booleans or other sections), as well
as some other features (such as single/double-quoted strings,
environment variable expansion, functions and nested include
statements). It makes it very easy to add configuration file capability
to a program using a simple API. 

The goal of libConfuse is not to be the configuration file parser
library with a gazillion of features. Instead, it aims to be easy to use
and quick to integrate with your code. libConfuse was called libcfg
before, but was changed to not confuse with other similar libraries.

%package -n lib%name
Summary: Dynamic libraries from %name
Group: System/Libraries

%description -n lib%name
Dynamic libraries from %name.

%package -n lib%name-devel
Summary: Files for developing applications that use %name
Requires: lib%name = %version
Group: Development/C

%description -n lib%name-devel
The header files and man pages for developing applications that use
%name.

%package -n lib%name-doc
Summary: Development documentation for %name
Group: Development/C
BuildArch: noarch

%description -n lib%name-doc
Documentation for developing programs based on %name

%prep
%setup
%__subst '/^AM_CFLAGS/s/-Werror//' src/Makefile.am
%autoreconf

%build
%configure \
	--disable-static \
	--enable-shared
%make_build
%make_build -C tests check

%install
%makeinstall
%find_lang %name
mkdir -p %buildroot%_man3dir/
install doc/man/man3/* %buildroot%_man3dir/

%files -n lib%name -f %name.lang
%_libdir/*.so.*
%doc AUTHORS README.md LICENSE


%files -n lib%name-devel
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/*.pc

%files -n lib%name-doc
%doc doc/{tutorial-html,html}/
%_man3dir/*


%changelog
