# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-golang
BuildRequires: rpm-build-golang
# END SourceDeps(oneline)
BuildRequires: libgudev-gir
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %_var
%global repo go-gir-generator

Name: deepin-gir-generator
Version: 3.0.4
Release: alt2

Summary: Generate static golang bindings for GObject

License: GPL-3.0+
Group: Other
Url: https://github.com/linuxdeepin/go-gir-generator

Source: %url/archive/%version/%repo-%version.tar.gz
Source1: vendor.tar
Source44: import.info
Patch: deepin-gir-generator-3.0.4-upstream-fixes-file-close.patch

BuildArch: noarch

Provides: golang(gir/gobject-2.0)
Provides: golang(gir/gio-2.0)
Provides: golang(gir/glib-2.0)
Provides: golang(gir/gudev-1.0)

BuildRequires: pkgconfig(gobject-introspection-1.0)
BuildRequires: pkgconfig(gudev-1.0)
BuildRequires: pkgconfig(gdk-3.0)

%description
Generate static golang bindings for GObject

%prep
%setup -n %repo-%version -a1
%patch -p1
sed -e 's|gopath|vendor|;' \
    -e '/rm -rf/d;' \
    -i Makefile

%build
export GOPATH="$(pwd)/vendor:%go_path"
export GOFLAGS="-mod=vendor"
export GO111MODULE="on"
%make_build

%install
%makeinstall_std

%files
%doc README.md
%doc --no-dereference LICENSE
%go_path/src/github.com/linuxdeepin/go-gir/

%changelog
