%define qdoc_found %{expand:%%(if [ -e %_dqt5_bindir/qdoc ]; then echo 1; else echo 0; fi)}
%global qt_module dqtwayland

Name: dqt5-wayland
Version: 5.15.13
Release: alt0.dde.1

Group: System/Libraries
Summary: Qt5 - Wayland platform support and QtCompositor module
Url: http://qt.io/
License: LGPLv2 / GPLv3

Source: %qt_module-everywhere-src-%version.tar
Source20: kde-qt-5.15.tar

# Automatically added by buildreq on Thu Jul 17 2014 (-bi)
# optimized out: elfutils fontconfig glibc-devel-static libGL-devel libX11-devel libXfixes-devel libcloog-isl4 libfreetype-devel libdqt5-core libdqt5-dbus libdqt5-gui libdqt5-network libdqt5-qml libdqt5-quick libstdc++-devel libwayland-client libwayland-client-devel libwayland-cursor libwayland-egl libwayland-server pkg-config python-base dqt5-base-devel dqt5-declarative-devel dqt5-script-devel ruby ruby-stdlibs wayland-devel xorg-compositeproto-devel xorg-fixesproto-devel xorg-xproto-devel
#BuildRequires: fontconfig-devel gcc-c++ git-core glib2-devel libEGL-devel libXcomposite-devel libXext-devel libXrender-devel libudev-devel libwayland-cursor-devel libwayland-egl-devel libwayland-server-devel libxkbcommon-devel python-module-protobuf dqt5-base-devel-static qt5-phonon-devel qt5-quick1-devel dqt5-tools-devel qt5-webkit-devel dqt5-xmlpatterns-devel rpm-build-ruby
BuildRequires(pre): rpm-build-ubt rpm-macros-dqt5 dqt5-tools
BuildRequires: fontconfig-devel gcc-c++ zlib-devel glib2-devel libEGL-devel libGLES-devel libXcomposite-devel libXext-devel libXrender-devel
BuildRequires: libinput-devel libts-devel libmtdev-devel
BuildRequires: libudev-devel libxkbcommon-devel
BuildRequires: libwayland-client-devel libwayland-cursor-devel libwayland-egl-devel libwayland-server-devel
BuildRequires: dqt5-base-devel-static dqt5-declarative-devel dqt5-tools-devel

Requires: libdqt5-gui = %_dqt5_version libdqt5-quick = %_dqt5_version

AutoProv: no
# find libraries
%add_findprov_lib_path %_dqt5_libdir

%description
%summary.

%package common
Summary: Common package for %name
Group: System/Configuration/Other
BuildArch: noarch
Requires: dqt5-base-common
%description common
Common package for %name

%package devel
Group: Development/KDE and QT
Summary: Development files for %name
Requires: %name-common = %EVR
Requires: dqt5-base-devel
%description devel
%summary.

%package devel-static
Group: Development/KDE and QT
Summary: Development files for %name
Requires: %name-common = %EVR
Requires: %name-devel
%description devel-static
%summary.

%package doc
BuildArch: noarch
Summary: Document for developing apps which will use Qt5 %qt_module
Group: Development/KDE and QT
Requires: %name-common = %EVR
%description doc
This package contains documentation for Qt5 %qt_module

%package -n libdqt5-compositor
Summary: Qt5 library
Group: System/Libraries
Requires: %name-common = %EVR
Requires: libdqt5-core = %_dqt5_version
%description -n libdqt5-compositor
%summary

%package -n libdqt5-waylandcompositor
Summary: Qt5 library
Group: System/Libraries
Requires: %name-common = %EVR
Requires: libdqt5-core = %_dqt5_version libdqt5-gui = %_dqt5_version
%description -n libdqt5-waylandcompositor
%summary

%package -n libdqt5-waylandclient
Summary: Qt5 library
Group: System/Libraries
Requires: %name-common = %EVR
Requires: libdqt5-core = %_dqt5_version libdqt5-gui = %_dqt5_version
%description -n libdqt5-waylandclient
%summary

%prep
%setup -qn %qt_module-everywhere-src-%version -a 20
ls -1d kde-qt-5.15/*.patch | sort | \
while read p; do
    echo $p
    patch -p1 < $p
done
syncqt.pl-dqt5 -version %version
#for d in gl nogl; do
#mkdir $d
#done

%build
#qmake_dqt5 CONFIG+=wayland-compositor
%qmake_dqt5 QT_BUILD_PARTS-=examples

%make_build
%if %qdoc_found
export QT_HASH_SEED=0
%make docs
%endif

%install
%install_dqt5
%if %qdoc_found
%make INSTALL_ROOT=%buildroot install_docs ||:
%endif

%files common
%doc LICENSE*EXCEPT*

%files
%_dqt5_plugindir/platforms/*
%_dqt5_plugindir/wayland-decoration-client/
%_dqt5_plugindir/wayland-graphics-integration-server/
%_dqt5_plugindir/wayland-graphics-integration-client/
%_dqt5_plugindir/wayland-shell-integration/
%dir %_dqt5_qmldir/QtWayland/
%_dqt5_qmldir/QtWayland/Compositor/
%dir %_dqt5_qmldir/QtWayland/Client/
%_dqt5_qmldir/QtWayland/Client/TextureSharing/

#%files -n libdqt5-compositor
#%_dqt5_libdir/libQt?Compositor.so.*
%files -n libdqt5-waylandcompositor
%_dqt5_libdir/libQt?WaylandCompositor.so.*
%files -n libdqt5-waylandclient
%_dqt5_libdir/libQt?WaylandClient.so.*

%files devel
%doc LICENSE*EXCEPT*
%_dqt5_bindir/qtwaylandscanner*
%_bindir/qtwaylandscanner*
%_dqt5_headerdir/Qt*/
%_dqt5_libdir/libQt*.so
%_dqt5_libdatadir/libQt*.so
%_dqt5_libdir/libQt*.prl
%_dqt5_libdatadir/libQt*.prl
%_dqt5_libdir/cmake/Qt*/
%_dqt5_libdir/pkgconfig/Qt*.pc
%_dqt5_archdatadir/mkspecs/modules/*.pri

%files doc
%if %qdoc_found
%_dqt5_docdir/*
%endif

%changelog
